import com.gridnine.xtrip.common.reports.model.AirTicketsTemplateReportTicket
import com.gridnine.xtrip.common.reports.model.AirTicketsTemplateReportTicketType
import com.gridnine.xtrip.server.reports.prepare.salesreports.nn.NNExchangeReportTicket
import com.gridnine.xtrip.server.reports.prepare.salesreports.nn.NNLetter;
import com.gridnine.xtrip.server.reports.prepare.salesreports.nn.NNReportHelper;
import com.gridnine.xtrip.server.reports.prepare.salesreports.nn.NNSellReportTicket;
import com.gridnine.xtrip.server.reports.prepare.salesreports.nn.NNTransportationType;
import com.gridnine.xtrip.server.reports.salesreports.render.nn.NNReportTestBase;;

//CREATING STYLES
createStyle(name: 'title',fontBold: true, h_span: 6, h_alignment: 'CENTER', v_alignment: 'CENTER', fontHeight:15)
createStyle(name: 'subTitleLabel',fontBold: true, h_alignment: 'RIGHT', v_alignment: 'CENTER', fontHeight:10)
createStyle(name: 'subTitleData',fontBold: false,  h_alignment: 'LEFT', v_alignment: 'CENTER', fontHeight:10)
createStyle(name: 'header',fontBold: false,  h_alignment: 'CENTER', v_alignment: 'CENTER', fontHeight:10, leftBorder:'MEDIUM', rightBorder:'MEDIUM', topBorder:'MEDIUM', bottomBorder:'MEDIUM', wrapText: true)
createStyle(name: 'data',fontBold: false,  h_alignment: 'CENTER', v_alignment: 'CENTER', fontHeight:10, leftBorder:'THIN', rightBorder:'THIN', topBorder:'THIN', bottomBorder:'THIN')
createStyle(name: 'textData',parent: 'data')
createStyle(name: 'textDataLeft',parent: 'textData',h_alignment: 'LEFT')
createStyle(name: 'index',parent: 'textData',h_alignment: 'RIGHT')
createStyle(name: 'indexBold',parent: 'index',fontBold: true,leftBorder:'MEDIUM', rightBorder:'MEDIUM', topBorder:'MEDIUM', bottomBorder:'MEDIUM')
createStyle(name: 'indexBoldSpanned11',parent: 'indexBold',v_span:11)
createStyle(name: 'nameBold',parent: 'textData',fontBold:true, wrapText: true,leftBorder:'MEDIUM', rightBorder:'MEDIUM', topBorder:'MEDIUM', bottomBorder:'MEDIUM')
createStyle(name: 'nameThin',parent: 'textData', wrapText: true)
createStyle(name: 'numberData',parent: 'data',h_alignment: 'RIGHT')
createStyle(name: 'numberDataBold',parent: 'numberData', fontBold: true,leftBorder:'MEDIUM', rightBorder:'MEDIUM', topBorder:'MEDIUM', bottomBorder:'MEDIUM')



NNLetter mvlLetter = new NNLetter()
NNLetter vvlLetter = new NNLetter()
NNLetter crimeaLetter = new NNLetter()
allTickets.each { AirTicketsTemplateReportTicket ticket ->
    switch (NNReportHelper.getTransportationType(ticket)) {
        case NNTransportationType.MVL:
            mvlLetter.addTicket(ticket)
            return;
        case NNTransportationType.VVL:
            vvlLetter.addTicket(ticket)
            return;
        case NNTransportationType.CRIMEA:
            crimeaLetter.addTicket(ticket)
            return;
    }
}
//REPORT
page{parameters['title']}{
    fitWidth(1)
    fitHeight(1)
    landscape(false)
    scale(85)
    //title
    rowHeight(15)
    4.times {nextColumn()}
    text("Приложение №", 'subTitleLabel')
    nextRow()
    4.times {nextColumn()}
    text("К субагентскому соглашению", 'subTitleLabel')
    nextRow()
    4.times {nextColumn()}
    text("№      от", 'subTitleLabel')
    nextRow()
    nextRow()
    rowHeight(20)
    text("Расчетное письмо", 'title')
    nextRow()
    text("Субагент ${parameters['AGENCY_NAME']}", 'title')
    nextRow()
    text("За период ${parameters['REPORT_PERIOD']}", 'title')
    nextRow();
    nextRow();
   //header
    rowHeight(45);
    setStyle('header')
    columnWidth(8)
    text('№');nextColumn()
    columnWidth(35)
    text('Раздел');nextColumn()
    columnWidth(15)
    text('Всего');nextColumn()
    columnWidth(15)
    text('В том числе бланки АК ВВЛ');nextColumn()
    columnWidth(15)
    text('В том числе бланки АК перевозки по Крыму');nextColumn()
    columnWidth(15)
    text('В том числе бланки АК МВЛ');
    nextRow()
    rowHeight(12)  
    //Сальдо
    text("1.",'indexBold');nextColumn()
    text("Сальдо на", 'nameBold');nextColumn()
    number(BigDecimal.ZERO, 'numberDataBold');nextColumn()
    number(BigDecimal.ZERO, 'numberDataBold');nextColumn()
    number(BigDecimal.ZERO, 'numberDataBold');nextColumn()
    number(BigDecimal.ZERO, 'numberDataBold');
    nextRow()
    //Продажа
    rowHeight(25)
    text("2.",'indexBold');nextColumn()
    text("Продажа (2.1.+2.2.+2.3.+2.4+2.5.+2.6.+2.7)", 'nameBold');nextColumn()
    formula("SUM(C12:C17)",'numberDataBold');nextColumn()
    formula("SUM(D12:D17)",'numberDataBold');nextColumn()
    formula("SUM(E12:E17)",'numberDataBold');nextColumn()
    formula("SUM(F12:F17)",'numberDataBold')
    /*Тариф*/
    /**/nextRow()
    rowHeight(12)
    /**/text("2.1.",'index');nextColumn()
    /**/text("Тариф", 'nameThin');nextColumn()
    /**/formula("SUM(D12:F12)",'numberData');nextColumn()
    /**/number(vvlLetter.sellTariff);nextColumn()
    /**/number(crimeaLetter.sellTariff);nextColumn()
    /**/number(mvlLetter.sellTariff);
    /*Тариф по обмену*/
    /**/nextRow()
    rowHeight(12)
    /**/text("2.2.",'index');nextColumn()
    /**/text("Тариф по обмену", 'nameThin');nextColumn()
    /**/formula("SUM(D13:F13)",'numberData');nextColumn()
    /**/number(vvlLetter.exchangeTariff);nextColumn()
    /**/number(crimeaLetter.exchangeTariff);nextColumn()
    /**/number(mvlLetter.exchangeTariff);
    /*Сумма по МСО*/
    /**/nextRow()
    rowHeight(12)
    /**/text("2.3.",'index');nextColumn()
    /**/text("Сумма по МСО", 'nameThin');nextColumn()
    /**/formula("SUM(D14:F14)",'numberData');nextColumn()
    /**/number(vvlLetter.sellMco);nextColumn()
    /**/number(crimeaLetter.sellMco);nextColumn()
    /**/number(mvlLetter.sellMco);
    /*Сбор за бланк*/
    /**/nextRow()
    rowHeight(12)
    /**/text("2.4.",'index');nextColumn()
    /**/text("Сбор за бланк", 'nameThin');nextColumn()
    /**/formula("SUM(D15:F15)",'numberData');nextColumn()
    /**/number(vvlLetter.sellTaxForBlank);nextColumn()
    /**/number(crimeaLetter.sellTaxForBlank);nextColumn()
    /**/number(mvlLetter.sellTaxForBlank);
    /*Топливный сбор (сборы SA, XT)*/
    /**/nextRow()
    rowHeight(12)
    /**/text("2.5.",'index');nextColumn()
    /**/text("Топливный сбор (сборы SA, XT)", 'nameThin');nextColumn()
    /**/formula("SUM(D16:F16)",'numberData');nextColumn()
    /**/number(vvlLetter.sellTaxForFuel);nextColumn()
    /**/number(crimeaLetter.sellTaxForFuel);nextColumn()
    /**/number(mvlLetter.sellTaxForFuel);
    /*Штрафные санкции*/
    /**/nextRow()
    rowHeight(12)
    /**/text("2.6.",'index');nextColumn()
    /**/text("Штрафные санкции", 'nameThin');nextColumn()
    /**/formula("SUM(D17:F17)",'numberData');nextColumn()
    /**/number(vvlLetter.sellTaxForFuel);nextColumn()
    /**/number(crimeaLetter.sellTaxForFuel);nextColumn()
    /**/number(mvlLetter.sellTaxForFuel);
    //Возврат
    nextRow()
    rowHeight(25)
    text("3.",'indexBold');nextColumn()
    text("Возврат (3.1.+3.2.+3.3+3.4)", 'nameBold');nextColumn()
    formula("SUM(C19:C22)",'numberDataBold');nextColumn()
    formula("SUM(D19:D22)",'numberDataBold');nextColumn()
    formula("SUM(E19:E22)",'numberDataBold');nextColumn()
    formula("SUM(F19:F22)",'numberDataBold')
    /*Тариф*/
    /**/nextRow()
    rowHeight(12)
    /**/text("3.1.",'index');nextColumn()
    /**/text("Возврат по тарифу", 'nameThin');nextColumn()
    /**/formula("SUM(D19:F19)",'numberData');nextColumn()
    /**/number(vvlLetter.refundTariff);nextColumn()
    /**/number(crimeaLetter.refundTariff);nextColumn()
    /**/number(mvlLetter.refundTariff);
    /*Возврат сбора за бланк (вынужд.возврат)*/
    /**/nextRow()
    rowHeight(25)
    /**/text("3.2.",'index');nextColumn()
    /**/text("Возврат сбора за бланк (вынужд.возврат)", 'nameThin');nextColumn()
    /**/formula("SUM(D20:F20)",'numberData');nextColumn()
    /**/number(vvlLetter.refundTaxForBlank);nextColumn()
    /**/number(crimeaLetter.refundTaxForBlank);nextColumn()
    /**/number(mvlLetter.refundTaxForBlank);
    /*Возврат МСО*/
    /**/nextRow()
    rowHeight(12)
    /**/text("3.3.",'index');nextColumn()
    /**/text("Возврат МСО", 'nameThin');nextColumn()
    /**/formula("SUM(D21:F21)",'numberData');nextColumn()
    /**/number(vvlLetter.refundMco);nextColumn()
    /**/number(crimeaLetter.refundMco);nextColumn()
    /**/number(mvlLetter.refundMco);
    /*Возврат топливный сбор*/
    /**/nextRow()
    rowHeight(12)
    /**/text("3.4.",'index');nextColumn()
    /**/text("Возврат топливный сбор", 'nameThin');nextColumn()
    /**/formula("SUM(D22:F22)",'numberData');nextColumn()
    /**/number(vvlLetter.refundTaxForFuel);nextColumn()
    /**/number(crimeaLetter.refundTaxForFuel);nextColumn()
    /**/number(mvlLetter.refundTaxForFuel);
    //Комиссионные (4.1.+4.2.+4.3. -4.4.-4.5)
    nextRow()
    rowHeight(25)
    text("4.",'indexBold');nextColumn()
    text("Комиссионные (4.1.+4.2.+4.3. -4.4.-4.5)", 'nameBold');nextColumn()
    formula("SUM(C24:C26)-C27-C28",'numberDataBold');nextColumn()
    formula("SUM(D24:D26)-D27-D28",'numberDataBold');nextColumn()
    formula("SUM(E24:E26)-E27-E28",'numberDataBold');nextColumn()
    formula("SUM(F24:F26)-F27-F28",'numberDataBold')
    /*в т.ч. от продажи а/б*/
    /**/nextRow()
    rowHeight(12)
    /**/text("4.1.",'index');nextColumn()
    /**/text("в т.ч. от продажи а/б", 'nameThin');nextColumn()
    /**/formula("SUM(D24:F24)",'numberData');nextColumn()
    /**/number(vvlLetter.sellTicketCommission);nextColumn()
    /**/number(crimeaLetter.sellTicketCommission);nextColumn()
    /**/number(mvlLetter.sellTicketCommission);
    /*в т.ч. от обмена а/б*/
    /**/nextRow()
    rowHeight(12)
    /**/text("4.2.",'index');nextColumn()
    /**/text("в т.ч. от обмена а/б", 'nameThin');nextColumn()
    /**/formula("SUM(D25:F25)",'numberData');nextColumn()
    /**/number(vvlLetter.exchangeTicketCommission);nextColumn()
    /**/number(crimeaLetter.exchangeTicketCommission);nextColumn()
    /**/number(mvlLetter.exchangeTicketCommission);
    /*в т.ч. от продажи багажа*/
    /**/nextRow()
    rowHeight(12)
    /**/text("4.3.",'index');nextColumn()
    /**/text("в т.ч. от продажи багажа", 'nameThin');nextColumn()
    /**/formula("SUM(D26:F26)",'numberData');nextColumn()
    /**/number(vvlLetter.sellLuggageCommission);nextColumn()
    /**/number(crimeaLetter.sellLuggageCommission);nextColumn()
    /**/number(mvlLetter.sellLuggageCommission);
    /*в т.ч. от возврата багажа*/
    /**/nextRow()
    rowHeight(12)
    /**/text("4.4.",'index');nextColumn()
    /**/text("в т.ч. от возврата багажа", 'nameThin');nextColumn()
    /**/formula("SUM(D27:F27)",'numberData');nextColumn()
    /**/number(vvlLetter.refundLuggageCommission);nextColumn()
    /**/number(crimeaLetter.refundLuggageCommission);nextColumn()
    /**/number(mvlLetter.refundLuggageCommission);
    /*в т.ч. от возврата а/б*/
    /**/nextRow()
    rowHeight(12)
    /**/text("4.5.",'index');nextColumn()
    /**/text("в т.ч. от возврата а/б", 'nameThin');nextColumn()
    /**/formula("SUM(D28:F28)",'numberData');nextColumn()
    /**/number(vvlLetter.refundTicketCommission);nextColumn()
    /**/number(crimeaLetter.refundTicketCommission);nextColumn()
    /**/number(mvlLetter.refundTicketCommission);
    //Сумма по претензиям 
    nextRow()
    rowHeight(25)
    text("5.",'indexBold');nextColumn()
    text("Сумма по претензиям ", 'nameBold');nextColumn()
    number(null,'numberDataBold');nextColumn()
    number(null,'numberDataBold');nextColumn()
    number(null,'numberDataBold');nextColumn()
    number(null,'numberDataBold');
    //Итого по всем формам оплаты      
    nextRow()
    rowHeight(25)
    text("6.",'indexBold');nextColumn()
    text("Итого по всем формам оплаты", 'nameBold');nextColumn()
    formula("SUM(C31:C35)",'numberDataBold');nextColumn()
    formula("SUM(D31:D35)",'numberDataBold');nextColumn()
    formula("SUM(E31:E35)",'numberDataBold');nextColumn()
    formula("SUM(F31:F35)",'numberDataBold')
    /*Наличные*/
    /**/nextRow()
    rowHeight(12)
    /**/text("6.1.",'index');nextColumn()
    /**/text("Наличные", 'nameThin');nextColumn()
    /**/formula("SUM(D31:F31)",'numberData');nextColumn()
    /**/number(vvlLetter.cacheFop);nextColumn()
    /**/number(crimeaLetter.cacheFop);nextColumn()
    /**/number(mvlLetter.cacheFop);
    /*Продажа в кредит депутаты*/
    /**/nextRow()
    rowHeight(12)
    /**/text("6.2.",'index');nextColumn()
    /**/text("Продажа в кредит депутаты", 'nameThin');nextColumn()
    /**/formula("SUM(D32:F32)",'numberData');nextColumn()
    /**/number(vvlLetter.creditFop);nextColumn()
    /**/number(crimeaLetter.creditFop);nextColumn()
    /**/number(mvlLetter.creditFop);
    /*Продажа по пластиковым картам*/
    /**/nextRow()
    rowHeight(12)
    /**/text("6.3.",'index');nextColumn()
    /**/text("Продажа по пластиковым картам", 'nameThin');nextColumn()
    /**/formula("SUM(D33:F33)",'numberData');nextColumn()
    /**/number(vvlLetter.ccFop);nextColumn()
    /**/number(crimeaLetter.ccFop);nextColumn()
    /**/number(mvlLetter.ccFop);
    /*Организации-клиенты*/0
    /**/nextRow()
    rowHeight(12)
    /**/text("6.4.",'index');nextColumn()
    /**/text("Организации-клиенты", 'nameThin');nextColumn()
    /**/formula("SUM(D34:F34)",'numberData');nextColumn()
    /**/number(vvlLetter.invoiceFop);nextColumn()
    /**/number(crimeaLetter.invoiceFop);nextColumn()
    /**/number(mvlLetter.invoiceFop);
    /*Продажа по ВПД*/
    /**/nextRow()
    rowHeight(12)
    /**/text("6.5.",'index');nextColumn()
    /**/text("Продажа по ВПД", 'nameThin');nextColumn()
    /**/formula("SUM(D35:F35)",'numberData');nextColumn()
    /**/number(vvlLetter.vpdFop);nextColumn()
    /**/number(crimeaLetter.vpdFop);nextColumn()
    /**/number(mvlLetter.vpdFop);
    //Итого к перечислению в АК
    nextRow()
    rowHeight(25)
    text("7.",'indexBold');nextColumn()
    text("Итого к перечислению в АК", 'nameBold');nextColumn()
    formula("C31-C24",'numberDataBold');nextColumn()
    formula("D31-D24",'numberDataBold');nextColumn()
    formula("E31-E24",'numberDataBold');nextColumn()
    formula("F31-F24",'numberDataBold')
    //Перечислено
    nextRow()
    rowHeight(25)
    text("8.",'indexBoldSpanned11');nextColumn()
    text("Перечислено", 'nameBold');nextColumn()
    number(null,'numberDataBold');nextColumn()
    number(null,'numberDataBold');nextColumn()
    number(null,'numberDataBold');nextColumn()
    number(null,'numberDataBold');nextColumn()
    nextRow()
    rowHeight(12)
    nextColumn()
    text('№ п/п   Дата  Организация   Период','textDataLeft');
    4.times{nextColumn();text(null,'textData')}
    2.times{nextRow();nextColumn();text('№        от ','textDataLeft');4.times{nextColumn();text(null,'textData')}}
    7.times{nextRow();5.times{nextColumn();text(null,'textData')}}
    //Итого к перечислению в АК
    nextRow()
    rowHeight(25)
    text("7.",'indexBold');nextColumn()
    text("Сальдо на", 'nameBold');nextColumn()
    formula("C10-C36+C37",'numberDataBold');nextColumn()
    formula("D10-D36+D37",'numberDataBold');nextColumn()
    formula("E10-E36+E37",'numberDataBold');nextColumn()
    formula("F10-F36+F37",'numberDataBold')
    nextRow()
    rowHeight(12)
    nextRow()
    nextColumn()
    text("Генеральный директор", 'subTitleLabel');
}

