import com.gridnine.xtrip.common.reports.model.AirTicketsTemplateReportTicket
import com.gridnine.xtrip.common.reports.model.AirTicketsTemplateReportTicketType
import com.gridnine.xtrip.server.reports.prepare.salesreports.nn.NNReportHelper;
import com.gridnine.xtrip.server.reports.prepare.salesreports.nn.NNSellReportTicket;
import com.gridnine.xtrip.server.reports.prepare.salesreports.nn.NNTransportationType
import com.gridnine.xtrip.server.reports.prepare.salesreports.nn.NNVoidReportTicket;
import com.gridnine.xtrip.server.reports.salesreports.render.nn.NNReportTestBase;;

//CREATING STYLES
createStyle(name: 'title',fontBold: true, h_span: 3, h_alignment: 'CENTER', v_alignment: 'CENTER', fontHeight:20)
createStyle(name: 'subTitleLabel',fontBold: true, h_span: 2, h_alignment: 'RIGHT', v_alignment: 'CENTER', fontHeight:10)
createStyle(name: 'subTitleData',fontBold: false,  h_alignment: 'LEFT', v_alignment: 'CENTER', fontHeight:10)
createStyle(name: 'header',fontBold: false,  h_alignment: 'CENTER', v_alignment: 'CENTER', fontHeight:10, leftBorder:'MEDIUM', rightBorder:'MEDIUM', topBorder:'MEDIUM', bottomBorder:'MEDIUM', wrapText: true)
createStyle(name: 'data',fontBold: false,  h_alignment: 'CENTER', v_alignment: 'CENTER', fontHeight:10, leftBorder:'THIN', rightBorder:'THIN', topBorder:'THIN', bottomBorder:'THIN')
createStyle(name: 'textData',parent: 'data')
createStyle(name: 'numberData',parent: 'data',h_alignment: 'RIGHT')
createStyle(name: 'dateData',parent: 'data',h_alignment: 'RIGHT',format: 'm/d/yy')
createStyle(name: 'totalTitle', parent: 'header', h_span: 2, h_alignment: 'RIGHT', fontBold: true)
createStyle(name: 'totalNumber',parent: 'totalTitle',  h_span: 1)


def tickets = []
allTickets.each { AirTicketsTemplateReportTicket ticket ->
    if(ticket.type == AirTicketsTemplateReportTicketType.MEMO) {
        return;
    }
    tickets << new NNVoidReportTicket(ticket)
}
def footer = {
    nextRow()
    rowHeight(12)
    nextRow()
    text("Исполнил", 'subTitleLabel');
    nextRow()
    nextRow()
    text("Подпись", 'subTitleLabel');
}
//REPORT
page{"аннуляция"}{
    //title
    rowHeight(30)
    text("Аннулирование",'title')
    nextRow()
    nextRow()
    rowHeight(15)
    text("Субагент", 'subTitleLabel')
    nextColumn()
    text(parameters['AGENCY_NAME'], 'subTitleData')
    nextRow()
    text("Период",'subTitleLabel')
    nextColumn()
    text(parameters['REPORT_PERIOD'], 'subTitleData')
    //header
    nextRow()
    nextRow()
    rowHeight(40);
    setStyle('header')
    text('№');nextColumn();
    columnWidth(20);
    text('Номер документа');nextColumn();
    columnWidth(10);
    text('Дата продажи');
    int rowCount = 0;
    tickets.each {NNVoidReportTicket ticket ->
        rowCount++
        nextRow()
        rowHeight(15)
        number(BigDecimal.valueOf(rowCount), 'numberData');nextColumn();
        text(ticket.ticketNumber, 'textData');nextColumn();
        date(ticket.voidDate, 'dateData');
    }
    nextRow();
    if(rowCount >0) {
        text("Итого аннулировано БСО", 'totalTitle');
        nextColumn()
        formula("COUNTA(C7:C${6+rowCount})", 'totalNumber')
        footer()
        return
    }
    rowHeight(15)
    text("Итого", 'totalTitle');
    nextColumn()
    number(null, 'totalNumber')
    footer()
}

