import com.gridnine.xtrip.common.reports.model.AirTicketsTemplateReportTicket

//CREATING STYLES
createStyle(name: 'baseStyle', fontBold: true,  h_alignment: 'CENTER', v_alignment: 'CENTER', fontHeight:12)
createStyle(name: 'bigHeader', parent: 'baseStyle', fontHeight:18)
createStyle(name: 'midHeader', parent: 'baseStyle',h_alignment: 'LEFT')
createStyle(name: 'smallHeader', parent:'baseStyle', fontHeight:8, h_alignment: 'RIGHT')
createStyle(name: 'smallHeaderCenter', parent: 'smallHeader', h_alignment: 'CENTER')
createStyle(name: 'tableHeader', parent: 'baseStyle', fontHeight:11, leftBorder:'MEDIUM', rightBorder:'MEDIUM', topBorder:'MEDIUM', bottomBorder:'MEDIUM')
createStyle(name: 'tableContent', parent: 'baseStyle', fontHeight:11, fontBold: false, leftBorder:'THIN', rightBorder:'THIN', topBorder:'THIN', bottomBorder:'THIN')
createStyle(name: 'textData', parent: 'tableContent')
createStyle(name: 'textDataBold', parent: 'tableContent', fontBold: true)
createStyle(name: 'dateData', format: 'm/d/yy', parent: 'tableContent')
createStyle(name: 'dateDataBold', format: 'm/d/yy', parent: 'tableContent', fontBold: true)
createStyle(name: 'numberData', format: '#,##0.00', parent: 'tableContent')
createStyle(name: 'emptyNumberData', parent: 'tableContent')
createStyle(name: 'numberDataBold', format: '#,##0.00', parent: 'tableContent', fontBold: true)

//ADDITIONAL FUNCTIONS
class Formula{
    String formula
    Formula(){}
    Formula(String formula){
        this.formula = formula
    }

    static Formula getSumFormulaByRow(String start, String end){
        return new Formula('SUM(' + start + ':' + end + ')')
    }
    static Formula getSumFormulaByCell(String... index){
        def formula = ''
        for(int i=0; i<index.size(); i++){
            if(i == 0){
                formula += index[i]
            }else{
                formula += ',' + index[i]
            }
        }
        return new Formula('SUM(' + formula + ')')
    }
}

def cellFill = { value ->
    if (value != null) {
        if (value instanceof Number) {
            number(value,'numberData')
        } else if (value instanceof Date) {
            date(value,'dateData')
        } else if (value instanceof Formula){
            formula(value.formula,'numberData')
        } else {
            text(value, 'textData')
        }
    }
}

def cellFillBold = { value ->
    if (value != null) {
        if (value instanceof Number) {
            number(value,'numberDataBold')
        } else if (value instanceof Date) {
            date(value,'dateDataBold')
        } else {
            text(value, 'textDataBold')
        }
    }
}

def nextColumnEmptyContent = {
    cellFill('')
    nextColumn()
}

def reportHeader = {
    rowHeight(20)
    nextColumn()
    text('Продажа а/б', 'bigHeader', 9, 1)
    2.times {nextRow()}
    text('Владелец БСО', 'baseStyle', 4, 1)
    5.times {nextColumn()}
    text('Период расчетов:' + parameters.REPORT_PERIOD, 'midHeader', 9, 1)
    nextRow()
    text('Код взаиморасчетов', 'baseStyle', 4, 1)
    nextRow()
    text('Регион перевозок', 'baseStyle', 4, 1)
    nextRow()

}

def fillReportEndRow = {String jobPosition->
    2.times {nextRow()}
    text(jobPosition, 'baseStyle', 4, 1)
    5.times {nextColumn()}
    text('ФИО', 'baseStyle', 2, 1)
}

def reportEnd = {
    fillReportEndRow('Испольнительный директор')
    fillReportEndRow('Главный бухгалтер')
    fillReportEndRow('Испольнитель')
}

def fillTableHeaderRef = {String content ->
    text(content, 'tableHeader')
    nextColumn()
}


def tableHeader = {
    rowHeight(15)
    columnWidth(12)
    fillTableHeaderRef('№ п/п')
    columnWidth(20)
    fillTableHeaderRef('Отв.перевозчик')
    columnWidth(15)
    fillTableHeaderRef('Вид БСО')
    columnWidth(25)
    fillTableHeaderRef('№ билета системный')
    columnWidth(18)
    fillTableHeaderRef('Дата продажи')
    columnWidth(12)
    fillTableHeaderRef('Кол. БСО')
    nextRow()
}

def tableBody = {
    int row = 1
    allTickets.each { AirTicketsTemplateReportTicket ticket ->
        cellFill(row)
        nextColumn()
        2.times {nextColumnEmptyContent()}
        cellFill(ticket.ticketNumber)
        nextColumn()
        cellFill(ticket.issueDate)
        nextColumn()
        nextColumnEmptyContent()
        nextRow()
        row++
    }
    text('Всего бланков', 'baseStyle', 5, 1)
    5.times {nextColumn()}
    cellFill(Formula.getSumFormulaByRow(cellIndex(-allTickets.size(), 0), cellIndex(-1, 0)))
    nextRow()
}

def reportBody = {
    tableHeader()
    tableBody()
}

page{'Cancelled registry'} {
    warn 'report version = ' + '0.1.0'

    reportHeader()
    reportBody()
    reportEnd()
}