import com.gridnine.xtrip.common.reports.model.AirTicketsTemplateReportTicket

//CREATING STYLES
createStyle(name: 'baseStyle', fontBold: true,  h_alignment: 'CENTER', v_alignment: 'CENTER', fontHeight:12)
createStyle(name: 'bigHeader', parent: 'baseStyle', fontHeight:18)
createStyle(name: 'midHeader', parent: 'baseStyle',h_alignment: 'LEFT')
createStyle(name: 'smallHeader', parent:'baseStyle', fontHeight:8, h_alignment: 'RIGHT')
createStyle(name: 'smallHeaderCenter', parent: 'smallHeader', h_alignment: 'CENTER')
createStyle(name: 'tableHeader', parent: 'baseStyle', fontHeight:11, leftBorder:'MEDIUM', rightBorder:'MEDIUM', topBorder:'MEDIUM', bottomBorder:'MEDIUM')
createStyle(name: 'tableContent', parent: 'baseStyle', fontHeight:11, fontBold: false, leftBorder:'THIN', rightBorder:'THIN', topBorder:'THIN', bottomBorder:'THIN')
createStyle(name: 'textData', parent: 'tableContent')
createStyle(name: 'textDataBold', parent: 'tableContent', fontBold: true)
createStyle(name: 'dateData', format: 'm/d/yy', parent: 'tableContent')
createStyle(name: 'dateDataBold', format: 'm/d/yy', parent: 'tableContent', fontBold: true)
createStyle(name: 'numberData', format: '#,##0.00', parent: 'tableContent')
createStyle(name: 'emptyNumberData', parent: 'tableContent')
createStyle(name: 'numberDataBold', format: '#,##0.00', parent: 'tableContent', fontBold: true)

//ADDITIONAL FUNCTIONS
class Formula {
    String formula
    Formula(){}
    Formula(String formula){
        this.formula = formula
    }

    static Formula getSumFormulaByRow (String start, String end) {
        return new Formula('SUM(' + start + ':' + end + ')')
    }
    static Formula getSumFormulaByCell (String... index) {
        def formula = ''
        for (int i=0; i<index.size(); i++) {
            if (i == 0) {
                formula += index[i]
            } else {
                formula += ',' + index[i]
            }
        }
        return new Formula('SUM(' + formula + ')')
    }
}

def cellFill = { value ->
    if (value != null) {
        if (value instanceof Number) {
            number(value,'numberData')
        } else if (value instanceof Date) {
            date(value,'dateData')
        } else if (value instanceof Formula){
            formula(value.formula,'numberData')
        } else {
            text(value, 'textData')
        }
    } else {
        text('', 'textData')
    }
}

def cellFillBold = { value ->
    if (value != null) {
        if (value instanceof Number) {
            number(value,'numberDataBold')
        } else if (value instanceof Date) {
            date(value,'dateDataBold')
        } else {
            text(value, 'textDataBold')
        }
    } else {
        text('', 'textDataBold')
    }
}

def nextColumnEmptyContent = {
    cellFill('')
    nextColumn()
}

def reportHeader = {
    rowHeight(20)
    nextColumn()
    text('Реестр Багажа', 'bigHeader', 9, 1)
    2.times {nextRow()}
    text('Владелец БСО', 'baseStyle', 4, 1)
    5.times {nextColumn()}
    text('Период расчетов:' + parameters.REPORT_PERIOD, 'midHeader', 9, 1)
    nextRow()
    text('Код взаиморасчетов', 'baseStyle', 4, 1)
    nextRow()
    text('Регион перевозок', 'baseStyle', 4, 1)
    nextRow()
}

def createSumFormulaForColumn = {int rowShift->
    return Formula.getSumFormulaByRow(cellIndex(rowShift, 0), cellIndex(-1, 0))
}

def reportEnd = {
    text('Итого', 'baseStyle', 10, 1)
    10.times { nextColumn() }
    if (allTickets.size() > 0) {
        int rowShift = -(allTickets.size())
        2.times {
            cellFill(createSumFormulaForColumn(rowShift))
            2.times { nextColumn() }
        }
        7.times {
            cellFill(createSumFormulaForColumn(rowShift))
            nextColumn()
        }
    }
}

def fillTableHeaderLug = {String content ->
    text(content, 'tableHeader')
    nextColumn()
}

def tableHeader = {
    rowHeight(15)
    columnWidth(10)
    fillTableHeaderLug('№ п/п')
    columnWidth(20)
    fillTableHeaderLug('Отв.перевозчик')
    columnWidth(15)
    fillTableHeaderLug('Вид БСО')
    columnWidth(25)
    fillTableHeaderLug('№ билета системный')
    columnWidth(12)
    fillTableHeaderLug('№ уч.')
    columnWidth(20)
    fillTableHeaderLug('Дата продажи')
    columnWidth(12)
    fillTableHeaderLug('АК')
    columnWidth(20)
    fillTableHeaderLug('Дата вылета')
    columnWidth(20)
    fillTableHeaderLug('Базовый тариф')
    columnWidth(20)
    fillTableHeaderLug('Маршрут')
    columnWidth(20)
    fillTableHeaderLug('Тариф за ед. изм.')
    columnWidth(15)
    fillTableHeaderLug('Вес/кол-во')
    columnWidth(15)
    fillTableHeaderLug('Тариф')
    columnWidth(12)
    fillTableHeaderLug('% ком')
    columnWidth(15)
    fillTableHeaderLug('Комиссия')
    columnWidth(15)
    fillTableHeaderLug('АГС')
    columnWidth(15)
    fillTableHeaderLug('ТН')
    columnWidth(15)
    fillTableHeaderLug('Такса SA')
    columnWidth(15)
    fillTableHeaderLug('Штраф')
    columnWidth(18)
    fillTableHeaderLug('Сборы Агента')
    columnWidth(15)
    fillTableHeaderLug('Итого')
    nextRow()
}

def tableBody = {
    int row = 0
    allTickets.each { AirTicketsTemplateReportTicket ticket ->
        3.times {nextColumnEmptyContent()}
        cellFill(ticket.ticketNumber)
        nextColumn()
        nextColumnEmptyContent()
        cellFill(ticket.issueDate)
        nextColumn()
        nextColumnEmptyContent()
        cellFill(ticket.departureDate)
        nextColumn()
        //TODO
        nextRow()
        row++
    }
}

def reportBody = {
    tableHeader()
    tableBody()
}

page{'Luggage registry'} {
    warn 'report version = ' + '0.1.0'

    reportHeader()
    reportBody()
    reportEnd()
}