import com.gridnine.xtrip.common.model.booking.BookingFile
import com.gridnine.xtrip.common.model.booking.ProductIndex
import com.gridnine.xtrip.common.model.booking.air.Commission
import com.gridnine.xtrip.common.model.booking.air.Product
import com.gridnine.xtrip.common.model.dict.ContractType
import com.gridnine.xtrip.common.model.entity.EntityStorage
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageSearchParameters
import com.gridnine.xtrip.common.model.helpers.AirProductHelper
import com.gridnine.xtrip.common.model.helpers.BookingHelper
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper
import com.gridnine.xtrip.common.model.profile.OrganizationIndex
import com.gridnine.xtrip.common.reports.model.AirTicketsTemplateReportTicket
import com.gridnine.xtrip.common.search.SearchCriterion
import com.gridnine.xtrip.common.search.SearchQuery

import java.text.SimpleDateFormat

//CREATING STYLES
createStyle(name: 'title',fontBold: true, h_span: 11, h_alignment: 'CENTER', v_alignment: 'CENTER', fontHeight:15)
createStyle(name: 'header',fontBold: true,  h_alignment: 'CENTER', v_alignment: 'CENTER', fontHeight:8, leftBorder:'MEDIUM', rightBorder:'MEDIUM', topBorder:'MEDIUM', bottomBorder:'MEDIUM', wrapText: true)
createStyle(name: 'headerTwo',fontBold: true,  h_alignment: 'CENTER', v_alignment: 'CENTER', fontHeight:8, leftBorder:'MEDIUM', rightBorder:'MEDIUM', topBorder:'MEDIUM', bottomBorder:'MEDIUM', wrapText: true, v_span: 2)
createStyle(name: 'headerThree',fontBold: true,  h_alignment: 'CENTER', v_alignment: 'CENTER', fontHeight:8, leftBorder:'MEDIUM', rightBorder:'MEDIUM', topBorder:'MEDIUM', bottomBorder:'MEDIUM', wrapText: true, h_span: 2)
createStyle(name: 'headerFour',fontBold: true,  h_alignment: 'CENTER', v_alignment: 'CENTER', fontHeight:8, leftBorder:'MEDIUM', rightBorder:'MEDIUM', topBorder:'MEDIUM', bottomBorder:'MEDIUM', wrapText: true, h_span: 9)
createStyle(name: 'data',fontBold: false,  h_alignment: 'CENTER', v_alignment: 'CENTER', fontHeight:8, leftBorder:'THIN', rightBorder:'THIN', topBorder:'THIN', bottomBorder:'THIN')
createStyle(name: 'textData',parent: 'data')
createStyle(name: 'numberData',parent: 'data',h_alignment: 'RIGHT', format: '#,##0.00',)
createStyle(name: 'dateData',parent: 'data',h_alignment: 'RIGHT',format: 'm/d/yy')
createStyle(name: 'subtotalTitle', parent: 'header', h_span: 6, h_alignment: 'RIGHT', fontBold: true)
createStyle(name: 'subtotalNumber',parent: 'subtotalTitle',  h_span: 1)
createStyle(name: 'totalTitle', parent: 'subtotalTitle', h_span: 3)
createStyle(name: 'totalNumber',parent: 'totalTitle', format: '#,##0.00')
createStyle(name: 'datePeriod',fontBold: true, h_span: 5, h_alignment: 'CENTER', v_alignment: 'CENTER', fontHeight:10 )
createStyle(name: 'subTitleStyle', fontBold: true, h_span: 3, h_alignment: 'LEFT', v_aligment: 'CENTER', fontHeight:10 )
createStyle(name: 'subTitleValueStyle', fontBold: true, h_span: 3, h_alignment: 'LEFT', v_aligment: 'CENTER', fontHeight: 10)
createStyle(name: 'numberStyle', fontBold: false, h_alignment: 'RIGHT', v_alignment: 'CENTER', fontHeight: 10 )
createStyle(name: 'sumTitle', leftBorder:'THIN', rightBorder:'THIN', topBorder:'THIN', bottomBorder:'THIN', h_span: 4, h_alignment: 'LEFT', fontBold: true)
createStyle(name: 'sumNumber',fontBold: true,  h_alignment: 'RIGHT', v_alignment: 'CENTER', fontHeight:8, leftBorder:'THIN', rightBorder:'THIN', topBorder:'THIN', bottomBorder:'THIN', format: '#,##0.00')
createStyle(name: 'mainSignTitle', h_span: 3, h_alignment: 'LEFT', fontBold: true, fontHeight:8)
createStyle(name: 'subSignTitle', h_span: 3, h_alignment: 'LEFT', fontBold: false, fontHeight:8)
createStyle(name: 'fioStyle', h_span: 3, h_alignment: 'CENTER', fontBold: false, v_alignment: 'CENTER', fontHeight:8)
createStyle(name: 'signStyle', h_span: 5, h_alignment: 'CENTER', fontBold: false)
createStyle(name: 'endTextStyle', h_span: 13, h_alignment: 'LEFT', fontBold: false, fontHeight:8)




def periodBeginParameter = parameters['key-report-params']?.periodBegin;
def periodEndParameter = parameters['key-report-params']?.periodEnd;
def agencyName = parameters['key-report-params']?.agency;
def bcoOwner = parameters['BLANK_OWNER'];
def paymentType = ' ';
if( parameters['paymentType'] != null)
    paymentType = parameters['paymentType'];
def reportDate = parameters['REPORT_DATE']
def corpClient = parameters['CLIENT']
String corpClientStr = corpClient;
if(corpClientStr == null || corpClientStr.isEmpty())
{
    error("Не задан клиент")
    //throw new Exception("Не задан клиент")
    return
}
SearchQuery query = new SearchQuery();
query
        .getCriteria()
        .getCriterions()
        .add(
        SearchCriterion.ilike(
        OrganizationIndex.Property.shortName.name(),
        "%$corpClient%"));
List<OrganizationIndex> data = EntityStorage.get().search(

        OrganizationIndex.class, query,
        new EntityStorageSearchParameters().noCache(true)).getData();
def longName = "Не найдено имя";
if(data != null && data.size() > 0)
{
    longName = data.get(0).getName();
}
def format = new SimpleDateFormat('dd.MM.yy')
//ADDITIONAL FUNCTIONS
def sum = {BigDecimal... values ->
    BigDecimal result = BigDecimal.ZERO
    values.each {
        if(it != null){
            result = result.add(it)
        }
    }
    return result
}
def multi = {BigDecimal... values ->
    BigDecimal result = BigDecimal.ONE
    values.each {
        if(it == null){
            result == BigDecimal.ZERO
            return
        }
        result = result.multiply(it)
    }
    return result
}


def priceFactor = {def it->
    return ('REFUND'.equals(it.status?.name()) ||'EXCHANGE'.equals(it.status?.name()))? BigDecimal.ONE.negate(): BigDecimal.ONE
}
def fare =  {def it->
    return multi(BigDecimal.ONE, it.equivalentFare)
}
def taxes =  {def it->
    return multi(BigDecimal.ONE, it.taxesSum)
}
def penalty =  {def it->
    return it.penalty == null? BigDecimal.ZERO: it.penalty
}
def total =  {def AirTicketsTemplateReportTicket ticket, BigDecimal clientCommission ->
    BigDecimal total = BigDecimal.ZERO
    if(fare(ticket) != null)
    {
        total = total.add(fare(ticket))
    }
    if(clientCommission != null)
    {
        total = total.subtract(clientCommission)
    }
    if(ticket.getTaxes() != null)
    {
        BigDecimal agsTaxes = BigDecimal.ZERO;
        if(ticket.getTaxesSum() != null)
        {
            agsTaxes = ticket.getTaxesSum();
            if(ticket.getFuelChargeAmount() != null)
            {
                agsTaxes = agsTaxes.subtract(ticket.getFuelChargeAmount());
            }
            if(ticket.getRuTaxAmount() != null)
            {
                agsTaxes = agsTaxes.subtract(ticket.getRuTaxAmount());
            }
        }
        total = total.add(agsTaxes)
        total = total.add(ticket.getFuelChargeAmount())
        total = total.add(ticket.getRuTaxAmount())
        total = total.add(penalty(ticket))
    }
    return total
}

def bspCommissionAmount =  {def it->
    return multi(priceFactor(it), it.bspCommissionEquivalentAmount)
}


//REPORT
page{"ОБМЕН"}{
    //TITLE
    rowHeight(30)
    setStyle('title')
    text("Реестр по обмену перевозочных документов");
    //HEADER
    nextRow()
    text("$longName")
    nextRow()
    rowHeight(20)
    text('Владелец БСО', 'subTitleStyle')
    nextColumn()
    text("$bcoOwner", 'subTitleValueStyle')
    nextColumn()
    text("Период отчетности с " + format.format(periodBeginParameter) + " по " + format.format(periodEndParameter), 'datePeriod')
    nextRow()
    text('Код взаиморасчетов', 'subTitleStyle')
    nextColumn()
    text("$paymentType", 'subTitleValueStyle')
    nextRow()
    text("Регион перевозок", 'subTitleStyle')
    nextColumn()
    text("ВСЕ", 'subTitleValueStyle')
    nextRow()
    rowHeight(40)
    columnWidth(7)
    text('№ п/п', 'header')
    nextColumn()
    columnWidth(9)
    text('Вид БСО', 'header')
    nextColumn()
    columnWidth(14)
    text('Системный № документа', 'header')
    nextColumn()
    columnWidth(10)
    text('Дата продажи', 'header')
    nextColumn()
    columnWidth(9)
    text('Тариф', 'header')
    nextColumn()
    columnWidth(11)
    text('ТН', 'header')
    nextColumn()
    columnWidth(11)
    text('АГС', 'header')
    nextColumn()
    columnWidth(11)
    text('Такса РУ/ТТКП', 'header')
    nextColumn()
    columnWidth(11)
    text('Комиссия', 'header')
    nextColumn()
    columnWidth(11)
    text('Штраф', 'header')
    nextColumn()
    columnWidth(11)
    text('Итого', 'header')
    /*nextColumn()
     columnWidth(8)
     text('К БСО', 'header')*/
    def rowNumber = 1
    //DATA
    nextRow()
    rowHeight(10)
    String fareRow = cellIndex(0, 4)
    String comissionRow = cellIndex(0, 8)
    String agsRow = cellIndex(0, 6)
    String thRow = cellIndex(0, 5)
    String ttkpRow = cellIndex(0, 7)
    String penaltyRow = cellIndex(0, 9)
    String totalRow = cellIndex(0, 10)
    tickets{ AirTicketsTemplateReportTicket ticket ->

        rowHeight(10)
        text("$rowNumber",'textData')
        nextColumn()
        text(ticket.getBlankType().toString(),'textData')
        nextColumn()
        text(ticket.ticketNumber?.toString(),'textData')
        nextColumn()
        date(ticket.issueDate,'dateData')
        nextColumn()
        number(fare(ticket),'numberData')
        nextColumn()
        number(ticket?.getFuelChargeAmount(),'numberData')
        nextColumn()
        BigDecimal agsTaxes = BigDecimal.ZERO;
        if(ticket.getTaxesSum() != null)
        {
            agsTaxes = ticket.getTaxesSum();
            if(ticket.getFuelChargeAmount() != null)
            {
                agsTaxes = agsTaxes.subtract(ticket.getFuelChargeAmount());
            }
            if(ticket.getRuTaxAmount() != null)
            {
                agsTaxes = agsTaxes.subtract(ticket.getRuTaxAmount());
            }
        }
        number(agsTaxes,'numberData')
        nextColumn()
        number(ticket?.getRuTaxAmount(),'numberData')
        nextColumn()
        query = new SearchQuery();
        query
                .getCriteria()
                .getCriterions()
                .add(
                SearchCriterion.eq("navigationKey",
                ticket.getUid()));
        List<ProductIndex> pi =
                EntityStorage.get().search(ProductIndex.class, query).getData();
        BigDecimal clientCommission = BigDecimal.ZERO;
        BigDecimal prevClientCommission = BigDecimal.ZERO;
        if(pi != null && !pi.empty)
        {
            ProductIndex productIndex = pi.get(0);
            BookingFile bookingFile = (BookingFile)EntityStorage.get().resolve(productIndex.getSource()).getEntity();
            if(bookingFile != null)
            {
                Product product = (Product)BookingHelper.findProductByUid(productIndex.getNavigationKey(), bookingFile);
                Collection<Commission> clientComissions = GeneralProductHelper
                        .filterCommissions(GeneralProductHelper.getUnmodifiableCommissions(
                        product, ContractType.CLIENT),
                        GeneralProductHelper.commissionPropertyTypes)
                clientCommission = AirProductHelper
                        .calculateCommissionsEquivalentValue(clientComissions);
                if(clientCommission == null)
                    clientCommission = BigDecimal.ZERO;

                Product prevProduct = product.getPreviousProduct();
                if(prevProduct != null)
                {
                    Collection<Commission> prevClientComissions = GeneralProductHelper
                            .filterCommissions(GeneralProductHelper.getUnmodifiableCommissions(
                            prevProduct, ContractType.CLIENT),
                            GeneralProductHelper.commissionPropertyTypes)
                    prevClientCommission = AirProductHelper
                            .calculateCommissionsEquivalentValue(prevClientComissions);
                }
                if(prevClientCommission == null)
                    prevClientCommission = BigDecimal.ZERO;

            }
        }
        number(clientCommission.subtract(prevClientCommission),'numberData')
        nextColumn()
        number(penalty(ticket),'numberData')
        nextColumn()
        number(total(ticket, clientCommission.subtract(prevClientCommission)),'numberData')
        nextRow()
        rowNumber++;

    }
    if(rowNumber > 1)
    {
        text('Итого по странице','sumTitle')
        nextColumn()
        formula("SUM(${fareRow}:${cellIndex(-1,0)})",'sumNumber')
        nextColumn()
        formula("SUM(${thRow}:${cellIndex(-1,0)})",'sumNumber')
        nextColumn()
        formula("SUM(${agsRow}:${cellIndex(-1,0)})",'sumNumber')
        nextColumn()
        formula("SUM(${ttkpRow}:${cellIndex(-1,0)})",'sumNumber')
        nextColumn()
        formula("SUM(${comissionRow}:${cellIndex(-1,0)})",'sumNumber')
        nextColumn()
        formula("SUM(${penaltyRow}:${cellIndex(-1,0)})",'sumNumber')
        nextColumn()
        formula("SUM(${totalRow}:${cellIndex(-1,0)})",'sumNumber')
        nextRow()

        text('Итого по реестру','sumTitle')
        nextColumn()
        formula("SUM(${fareRow}:${cellIndex(-2,0)})",'sumNumber')
        nextColumn()
        formula("SUM(${thRow}:${cellIndex(-2,0)})",'sumNumber')
        nextColumn()
        formula("SUM(${agsRow}:${cellIndex(-2,0)})",'sumNumber')
        nextColumn()
        formula("SUM(${ttkpRow}:${cellIndex(-2,0)})",'sumNumber')
        nextColumn()
        formula("SUM(${comissionRow}:${cellIndex(-2,0)})",'sumNumber')
        nextColumn()
        formula("SUM(${penaltyRow}:${cellIndex(-2,0)})",'sumNumber')
        nextColumn()
        formula("SUM(${totalRow}:${cellIndex(-2,0)})",'sumNumber')
    }
    nextRow()
    nextRow()
    nextRow()
    text("Исполнительный директор", 'mainSignTitle')
    nextColumn()
    text("ФИО", 'fioStyle')
    nextColumn()
    text("___________________________________________________________________", 'signStyle')
    nextRow()
    nextRow()
    nextRow()
    text("Главный бухгалтер", 'mainSignTitle')
    nextColumn()
    text("ФИО", 'fioStyle')
    nextColumn()
    text("___________________________________________________________________", 'signStyle')
    nextRow()
    nextRow()
    nextRow()
    text("Исполнитель", 'subSignTitle')
    nextColumn()
    text("ФИО", 'fioStyle')
    nextColumn()
    text("___________________________________________________________________", 'signStyle')
    nextRow()
    nextRow()
    nextRow()


}

