import com.gridnine.xtrip.common.model.handlers.ProductStatusHandler
import com.gridnine.xtrip.common.reports.model.AirTicketsTemplateReportTicket;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.PassengerTypeValue;
import com.gridnine.xtrip.common.model.booking.ProductIndex;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.profile.Address;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import java.text.SimpleDateFormat;
import java.util.Locale;

// Styles
createStyle(name: 'title', h_alignment: 'CENTER', v_alignment: 'CENTER')
createStyle(name: 'titleH1', fontHeight: 14, parent: 'title')
createStyle(name: 'titleH2', fontHeight: 9, parent: 'title')
createStyle(name: 'titleH3', fontHeight: 7, parent: 'title')
createStyle(name: 'header', h_alignment: 'CENTER', v_alignment: 'CENTER', fontHeight: 7)
createStyle(name: 'columnHeader', parent: 'header')
createStyle(name: 'rowHeader', parent: 'header')
createStyle(name: 'data', h_alignment: 'CENTER', v_alignment: 'CENTER', fontHeight: 7)
createStyle(name: 'dataText', parent: 'data')
createStyle(name: 'dataDate', format: 'm/d/yy', parent: 'data')
createStyle(name: 'dataNumber', h_alignment: 'RIGHT', format: '#,##0.00', parent: 'data')
createStyle(name: 'wrap', wrapText: true)
createStyle(name: 'ahl', h_alignment: 'LEFT')
createStyle(name: 'ahc', h_alignment: 'CENTER')
createStyle(name: 'ahr', h_alignment: 'RIGHT')
createStyle(name: 'avt', v_alignment: 'TOP')
createStyle(name: 'avc', v_alignment: 'CENTER')
createStyle(name: 'avb', v_alignment: 'BOTTOM')
createStyle(name: 'aac', h_alignment: 'CENTER', v_alignment: 'CENTER')
createStyle(name: 'bold', fontBold: true)
createStyle(name: 'italic', fontItalic: true)
createStyle(name: 'bt', topBorder: 'THIN')
createStyle(name: 'bl', leftBorder: 'THIN')
createStyle(name: 'bb', bottomBorder: 'THIN')
createStyle(name: 'br', rightBorder: 'THIN')
createStyle(name: 'ba', topBorder: 'THIN', leftBorder: 'THIN', bottomBorder: 'THIN', rightBorder: 'THIN')
createStyle(name: 'grey25', foreground: 'GREY_25_PERCENT')
createStyle(name: 'locked', locked: true)

// Properties
def periodBeginParameter = parameters['key-report-params']?.periodBegin
def periodEndParameter = parameters['key-report-params']?.periodEnd
def supplierParameter = parameters['key-report-params']?.supplier
def agencyParameter = parameters['key-report-params']?.agency

def agencyName = {

    def organization = EntityStorage.get().resolve(agencyParameter)?.entity
    return organization ? ProfileHelper.getFullName(organization, LocaleHelper.getLocale('ru', 'RU'), false) : 'Не указано'
}

class Ticket
{
    int rowNumber;
    String salesPoint;
    String productType;
    String ticketPrefix;
    String ticketNumber;
    Date issueDate;
    String passengerName;
    String passport;
    String disableDocument;
    String passengerType;
    String fareBase;
    BigDecimal equalentFare;
    Date birthdayDate;
}

def createPage = { pageName, tickets ->

    page{pageName} {

        // Set portrait mode
        landscape(true)

        // Set narrow margins
        margin(0.25, 0.25, 0.75, 0.75)

        // Set scale
        scale(90)

        // Set preserve mode
        preserve(false)

        def format = new SimpleDateFormat('dd.MM.yy')

        if(pageName.equals("Kaliningrad")) {
            text("Реестр продаж воздушных перевозок по субсидируемым тарифам программы «Калининград»", 'titleH1', 13, 1);
        } else if(pageName.equals("Simferopol")) {
            text("Реестр продаж воздушных перевозок по субсидируемым тарифам программы «Симферополь»", 'titleH1', 13, 1);
        } else {
            text("Реестр продаж воздушных перевозок по субсидируемым тарифам программы «Дальний Восток»", 'titleH1', 13, 1);
        }

        nextRow()
        
        text("c " + format.format(periodBeginParameter) + " по " + format.format(periodEndParameter), 'titleH1', 13, 1);

        2.times{nextRow()}

        nextColumn()
        text('Перевозчик:', 'titleH2|ahr')
        nextColumn()
        text('ОАО "Аэрофлот"', 'titleH2|ahl')
        nextRow()

        nextColumn()
        text('Агентство:', 'titleH2|ahr')
        nextColumn()
        text(agencyName(), 'titleH2|ahl')
        nextRow()

        columnWidth(5)
        nextColumn()
        columnWidth(12)
        nextColumn()
        columnWidth(12)
        nextColumn()
        columnWidth(5)
        nextColumn()
        columnWidth(12)
        nextColumn()
        columnWidth(10)
        nextColumn()
        columnWidth(16)
        nextColumn()
        columnWidth(12)
        nextColumn()
        columnWidth(16)
        nextColumn()
        columnWidth(16)
        nextColumn()
        columnWidth(10)
        nextColumn()
        columnWidth(10)
        nextColumn()
        columnWidth(10)
        nextRow()

        text('№ п/п', 'columnHeader|ba')
        nextColumn()
        text('Пункт оформления перевозочного документа', 'columnHeader|wrap|ba')
        nextColumn()
        text('Наименование перевозочного документа', 'columnHeader|wrap|ba')
        nextColumn()
        text('Серия, номер перевозочного документа', 'columnHeader|wrap|ba', 2, 1)
        2.times{nextColumn()}
        text('Дата оформления перевозочного документа', 'columnHeader|wrap|ba')
        nextColumn()
        text('Фамилия. имя, отчество пассажира', 'columnHeader|wrap|ba')
        nextColumn()
        text('Паспорт / свидетельство о рождении', 'columnHeader|wrap|ba')
        nextColumn()
        text('Справка об инвалидности (номер и дата выдачи) / номер билета оформленного для перевозки инвалида', 'columnHeader|wrap|ba')
        nextColumn()
        text('Категория пассажира, ВЗР / РБ / ВЗР-инвалид / РБ-инвалид / сопровождающ.', 'columnHeader|wrap|ba')
        nextColumn()
        text('Вид тарифа', 'columnHeader|wrap|ba')
        nextColumn()
        text('Величина тарифа, руб.', 'columnHeader|wrap|ba')
        nextColumn()
        text('Дата рождения пассажира', 'columnHeader|wrap|ba')
        nextRow()

        // Data
        def rowNumber = 0;

        for(Ticket ticket : tickets) {

            number(ticket.rowNumber,'dataText|ba')
            nextColumn()
            text(ticket.salesPoint,'dataText|ba')
            nextColumn()
            text(ticket.productType,'dataText|ba')
            nextColumn()
            text(ticket.ticketPrefix,'dataText|ba')
            nextColumn()
            text(ticket.ticketNumber,'dataText|ba')
            nextColumn()
            date(ticket.issueDate,'dataDate|ba')
            nextColumn()
            text(ticket.passengerName,'dataText|ba')
            nextColumn()
            text(ticket.passport,'dataText|ba')
            nextColumn()
            text(ticket.disableDocument,'dataText|ba')
            nextColumn()
            text(ticket.passengerType,'dataText|ba')
            nextColumn()
            text(ticket.fareBase,'dataText|ba')
            nextColumn()
            number(ticket.equalentFare,'dataNumber|ba')
            nextColumn()
            date(ticket.birthdayDate,'dataDate|ba')
            nextRow()

            rowNumber++
        }
    }
}

int rowKalNumber = 0;
int rowSimferopolNumber = 0;
int rowEastFarNumber = 0;
List<Ticket> subTicketsKalin = new ArrayList<Ticket>();
List<Ticket> subTicketsSimferopol = new ArrayList<Ticket>();
List<Ticket> subTicketsFarEast = new ArrayList<Ticket>();

tickets{ AirTicketsTemplateReportTicket ticket ->
    if(ProductStatusHandler.getAllVoidStatuses().contains(ticket.status))
        return;
    Ticket subTicket = new Ticket();
    def salesPoint = " "
    if(ticket.salesPoint != null)
    {
        SalesPoint salesPointEn =  (SalesPoint)EntityStorage.get().resolve(ticket.salesPoint)?.getEntity();
        List<Address> addresses = salesPointEn.getAddresses();
        if(addresses != null && !addresses.isEmpty())
        {
            Address address = addresses.get(0);
            DictionaryReference<GeoLocation> cityLocRef = address.getCity();
            if(cityLocRef != null)
                salesPoint =  cityLocRef.toString(new Locale("ru")).toUpperCase();
        }
    }
    subTicket.setSalesPoint(salesPoint);
    subTicket.setProductType("Авиабилет");
    subTicket.setTicketPrefix(ticket.validatingCarrierNumber)
    subTicket.setTicketNumber(ticket.ticketNumber);
    subTicket.setIssueDate(ticket.issueDate);
    subTicket.setPassengerName(ticket.getNameInGDS());
    subTicket.setPassport(ticket.travellerPassportNumber);
    def travellerType = " "
    PassengerTypeValue ptv = DictHelper.getPassengerTypeValue(ticket.travellerType);
    if(ptv != null)
    {
        if(ptv.equals(PassengerTypeValue.ADULT)
        || ptv.equals(PassengerTypeValue.SENIOR)
        || ptv.equals(PassengerTypeValue.YOUTH)
        || ptv.equals(PassengerTypeValue.STUDENT))
        {
            travellerType = "ВЗР"
        }
        else if(ptv.equals(PassengerTypeValue.CHILD)
        || ptv.equals(PassengerTypeValue.CHILD_UNACCOMPANIED))
        {
            travellerType = "РБ"
        }
        else if(ptv.equals(PassengerTypeValue.INFANT) ||
        ptv.equals(PassengerTypeValue.INFANT_WITH_SITE))
        {
            travellerType = "РМ"
        }
        else if(ptv.equals(PassengerTypeValue.ADULT_COMPANION) ||
        ptv.equals(PassengerTypeValue.FAMILY_ACCOMPANIED))
        {
            travellerType = "Сопровождающий"
        }
    }
    subTicket.setPassengerType(travellerType);
    subTicket.setFareBase(ticket.fareBasisLine?.replaceAll('/', ', '))
    if(ticket.equivalentFare == null)
        ticket.equivalentFare = BigDecimal.ZERO;
    if(ticket.getStatus() == ProductStatus.REFUND || ticket.getStatus() == ProductStatus.EXCHANGE)
        ticket.equivalentFare = ticket.equivalentFare.negate();
    subTicket.setEqualentFare(ticket.equivalentFare);
    subTicket.setBirthdayDate(ticket.travellerBirthday);
    if(ticket.routeLine.contains("KGD"))
    {
        rowKalNumber++;
        subTicket.setRowNumber(rowKalNumber);
        subTicketsKalin.add(subTicket);
    }
    else if(ticket.routeLine.contains("SIP"))
    {
        rowSimferopolNumber++;
        subTicket.setRowNumber(rowSimferopolNumber);
        subTicketsSimferopol.add(subTicket);
    }
    else
    {
        rowEastFarNumber++;
        subTicket.setRowNumber(rowEastFarNumber);
        subTicketsFarEast.add(subTicket);
    }
}
createPage("Kaliningrad", subTicketsKalin);
createPage("Simferopol", subTicketsSimferopol);
createPage("FarEast", subTicketsFarEast);