import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex
import com.gridnine.xtrip.common.model.profile.OrganizationType;
import com.gridnine.xtrip.common.search.SearchCriterion
import com.gridnine.xtrip.common.search.SearchQuery
import com.gridnine.xtrip.common.util.TextUtil;

SearchQuery query = new SearchQuery()

query.getCriteria().getCriterions().add(SearchCriterion.ne(OrganizationIndex.Property.code.name(), null))
query.getCriteria().getCriterions().add(SearchCriterion.contains(OrganizationIndex.Property.types.name(), OrganizationType.CORPORATE_CLIENT))

List<OrganizationIndex> indexes = EntityStorage.get().search(OrganizationIndex.class, query).getData()

for(OrganizationIndex index : indexes) {
    
    String code = index.getCode()
    
    if(code.length() == 10 && code.startsWith("D00")) {
        
        EntityContainer<Organization> organizationContainer = EntityStorage.get().resolve(index.getSource())
        
        if(organizationContainer != null) {
            
            Organization organization = organizationContainer.getEntity();
            
            organization.setCode("D11" + organization.getCode().substring(3))
            
            organizationContainer.getVersionInfo().setDataSource("organization-code-update-task")

            EntityStorage.get().save(organizationContainer, true)
        }
    }
}