import com.gridnine.xtrip.common.l10n.model.LocaleManager
import com.gridnine.xtrip.common.model.EntityContainer
import com.gridnine.xtrip.common.model.dict.CostCodeCategory
import com.gridnine.xtrip.common.model.dict.DictSearchCriterion
import com.gridnine.xtrip.common.model.dict.DictionaryCache
import com.gridnine.xtrip.common.model.entity.EntityStorage
import com.gridnine.xtrip.common.model.profile.CostCode
import com.gridnine.xtrip.common.model.profile.CostCodeProperties
import com.gridnine.xtrip.common.model.profile.CostCodeType
import com.gridnine.xtrip.common.model.profile.Organization
import com.gridnine.xtrip.common.model.profile.OrganizationIndex
import com.gridnine.xtrip.common.model.profile.OrganizationType
import com.gridnine.xtrip.common.search.SearchCriterion
import com.gridnine.xtrip.common.search.SearchQuery
import com.gridnine.xtrip.common.util.MiscUtil
import com.gridnine.xtrip.common.util.TextUtil

Set<CostCodeCategory> costCodeCategories = DictionaryCache.get().search(CostCodeCategory.class, DictSearchCriterion.eq(CostCodeCategory.Property.shortName.name(), "FARE TYPE"))

CostCodeCategory costCodeCategory = costCodeCategories.size() > 0 ? costCodeCategories.iterator().next() : null

if(costCodeCategory != null) {

    Locale locale = LocaleManager.get().getCurrentLocale()

    SearchQuery query = new SearchQuery()

    query.getCriteria().getCriterions().add(SearchCriterion.contains(OrganizationIndex.Property.types.name(), OrganizationType.CORPORATE_CLIENT))

    List<OrganizationIndex> indexes = EntityStorage.get().search(OrganizationIndex.class, query).getData()

    for(OrganizationIndex index : indexes) {

        EntityContainer<Organization> organizationContainer = EntityStorage.get().resolve(index.getSource())

        if(organizationContainer != null) {

            Organization organization = organizationContainer.getEntity()

            List<CostCodeType> costCodeTypes = new ArrayList<>(Arrays.asList(CostCodeType.values()));

            boolean found = false

            for(CostCodeProperties costCodeProperties : organization.getCostCodeProperties()) {

                costCodeTypes.remove(costCodeProperties.getType())

                if(MiscUtil.equals(costCodeProperties.getCategory(), costCodeCategory.toReference())) {

                    found = true
                    break
                }
            }

            if(!found && costCodeTypes.size() > 0) {

                CostCodeProperties costCodeProperties = new CostCodeProperties()

                costCodeProperties.setType(costCodeTypes.get(0))
                costCodeProperties.setCategory(costCodeCategory.toReference())

                String name = MiscUtil.findByLocale(costCodeCategory.getTranslations(), locale)

                if (TextUtil.isBlank(name) && !MiscUtil.equals(locale, Locale.ENGLISH)) {
                    name = MiscUtil.findByLocale(costCodeCategory.getTranslations(), Locale.ENGLISH)
                }

                if (TextUtil.isBlank(name) && costCodeCategory.getTranslations().size() > 0) {
                    result = costCodeCategory.getTranslations().values().iterator().next()
                }

                costCodeProperties.setName(name)
                costCodeProperties.setSabreDropList(true)

                organization.getCostCodeProperties().add(costCodeProperties)

                CostCode costCode = new CostCode()

                costCode.setCostCodeProperties(costCodeProperties)
                costCode.setValue("NONREFUNDABLE")
                costCode.setLocalValue("невозвратный")
                costCode.setEnglishValue("nonrefundable")

                organization.getCostCodes().add(costCode)

                costCode = new CostCode()

                costCode.setCostCodeProperties(costCodeProperties)
                costCode.setValue("REFUNDABLE")
                costCode.setLocalValue("возвратный")
                costCode.setEnglishValue("refundable")

                organization.getCostCodes().add(costCode)

                organizationContainer.getVersionInfo().setVersionNotes("update UDID task (XTR-4683)")

                EntityStorage.get().save(organizationContainer, true)
            }
        }
    }
}

