import java.io.BufferedReader;
import java.io.FileReader;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Map.Entry;


import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.server.storage.DictionaryStorage;


	def translation2Country = {
        DictionaryCache cache = Environment.getPublished(DictionaryCache.class);
        Map<String, Country> countries = cache.getAll(Country.class);
        Map<String, Country> result = new HashMap<String, Country>();
        for (Country country : countries.values()) {

            if (country.getTranslations().isEmpty()) {
                continue;
            }

            String translation = country.getTranslations().get(Locale.ENGLISH);
            if (translation == null) {
                translation =
                    country.getTranslations().values().iterator().next();
            }

            if (translation != null) {
                result.put(translation.toUpperCase(), country);
            }
        }

        return result;
    }


        BufferedReader br = null;


        try {
             br =
                new BufferedReader(
                    new FileReader("/tmp/iso_countries.csv"));

            List<Map<String, String>> recordss =
                new LinkedList<Map<String, String>>();

            int c = 0;
            while (true) {
                c++;
                String line = br.readLine();
                if (c == 1) {
                    continue;
                }

                if (line == null) {
                    break;
                }
                
                
                
                String[] parts = line.split(",");
                if(parts.length<13) continue;
                Map<String, String> m = new HashMap<String, String>();
                m.put("Common Name", parts[1]);
                m.put("ISO 3166-1 2 Letter Code", parts[10]);
                m.put("ISO 3166-1 3 Letter Code", parts[11]);
                m.put("ISO 3166-1 Number", parts[12]);
                recordss.add m;
            }

            def iso = [:];
            for (def record : recordss) {
                String commonName = record.get("Common Name");
                String iso2alpha = record.get("ISO 3166-1 2 Letter Code");
                String iso3alpha = record.get("ISO 3166-1 3 Letter Code");
                String isoNumeric = record.get("ISO 3166-1 Number");

                iso.put(commonName.toUpperCase(), ['iso2alpha' : iso2alpha,
                   'iso3alpha' : iso3alpha, 'isoNumeric' :isoNumeric]);
            }
        DictionaryStorage ds = DictionaryStorage.get();
		def mm = translation2Country()
            int processedCountries = 0;
			def iterator = mm.entrySet().iterator();
            while (iterator.hasNext()) {
				def entry = iterator.next();
                String translation = entry.getKey();

                def data = iso.get(translation);
                if (data != null) {
                    Country country = entry.getValue();

                    country.getCodeVariants().put(CodeSystem.ISO.name(),
                        data['iso2alpha']);
                    country.getCodeVariants().put(CodeSystem.ISO_ALPHA3.name(),
                        data['iso3alpha']);
                    country.getCodeVariants().put(
                        CodeSystem.ISO_NUMERIC.name(), data['isoNumeric']);

                    country.setDataSource("iso_countries")
                    ds.save(country);
					iterator.remove();
					

                    processedCountries++;
                }
            }

            message("complete. processed countries: "
                + processedCountries);
                
              mm.each{
              	def translation = it.getKey();
              	message(translation);
              }  
                
                
        }  finally {

            if (br != null) {
                br.close();
            }
        }

