import com.gridnine.xtrip.common.Environment
import com.gridnine.xtrip.server.ServerApplication
import org.apache.commons.io.FileUtils

def config = Environment.getPublished(ServerApplication.class).getConfiguration();
boolean httpSenderEnabled ="true".equalsIgnoreCase(config.get("http.booking.file.xml.sender.enabled"));
boolean bookingExportEnabled = "true".equalsIgnoreCase(config.get("booking.file.xml.exporter.enabled"));
boolean entityExportOldEnabled = "true".equalsIgnoreCase(config.get("entity.exporter.enabled"));
boolean entityExportJmsEnabled = "true".equalsIgnoreCase(config.get("entity.exporter.jms.enabled"));
boolean entityExportFileEnabled = "true".equalsIgnoreCase(config.get("entity.exporter.file.enabled"));

answer.booleanAnswer = httpSenderEnabled || bookingExportEnabled || entityExportOldEnabled || entityExportJmsEnabled || entityExportFileEnabled;
answer.textAnswer = "httpSenderEnabled: ${httpSenderEnabled}\n" +
        "bookingExportEnabled: ${bookingExportEnabled}\n" +
        "entityExportOldEnabled: ${entityExportOldEnabled}\n" +
        "entityExportJmsEnabled: ${entityExportJmsEnabled}\n" +
        "entityExportFileEnabled: ${entityExportFileEnabled}\n";
def file = new File(Environment.configurationFolder, "boot.properties")
if(file.exists()) {
    answer.textAnswer = answer.textAnswer + FileUtils.readFileToString(file);
}