package com.gridnine.xtrip.server.model.rules.docs
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.rules.RulesEnvironment;
import com.gridnine.xtrip.common.rules.elements.RuleAction;
import com.gridnine.xtrip.common.rules.elements.RuleCondition;
import com.gridnine.xtrip.common.rules.elements.RuleProperty;
import com.gridnine.xtrip.common.rules.elements.RuleTarget;
import com.gridnine.xtrip.common.util.XmlUtil;

import groovy.xml.MarkupBuilder;

def targetsDescription = [:]
def conditionsDescription = [:]
def propertiesDescription = [:]
def propertyValuesDescription = [:]
def actionsDescription = [:]
def actionValuesDescription = [:]
File file = new File("docs/misc/rules/export.xml")
def readDescriptions = {Node node, String section, Map map ->
    node."${section}".each{
        it.item.each{
            String format = it.@format
            def value = new ItemDescription()
            map[it.@id] =  value
            if(format == "text" || !format){
                value.content =it.text()
                value.type ="text"
                return
            }
            StringWriter writer = new StringWriter();
            XmlNodePrinter pw = new XmlNodePrinter(new PrintWriter(writer))
            pw.preserveWhitespace = true
            pw.print(it.children()[0])
            value.content =writer.toString()
            if(format == "xml"){
                value.type ="xml"
            } else{
                value.type ="html"
            }
        }
    }
}
def writeDescriptions = {MarkupBuilder builder, ItemDescription descr ->
    delegate = builder;
    if(!descr){
        td("")
        return;
    }
    if(descr.type == "text"){
        td(descr.content)
        return
    }
    if(descr.type == "html"){
        td{
            mkp.yieldUnescaped(descr.content)
        }
        return
    }
    if(descr.type == "xml"){
        String value = descr.content
        value = value.replaceAll("<comment>",'<!-- ').replaceAll("</comment>",' -->')
        td{
            pre{
                mkp.yield(value)
            }
        }
        return
    }
}



if(file.exists()){
    def node = new XmlParser().parse(file)
    readDescriptions(node, "targets", targetsDescription)
    readDescriptions(node, "conditions", conditionsDescription)
    readDescriptions(node, "properties", propertiesDescription)
    readDescriptions(node, "propertyValues", propertyValuesDescription)
    readDescriptions(node, "actions", actionsDescription)
    readDescriptions(node, "actionValues", actionValuesDescription)
}

def html = new MarkupBuilder(sb)

html.doubleQuotes = true
html.expandEmptyElements = true
html.omitEmptyAttributes = false
html.omitNullAttributes = false
html.html {
    head { title ('Описание формата файла выгрузки правил') }
    body {
        h1("Описание формата файла выгрузки правил")
        h2("Структура файла")
        pre{ mkp.yield("""
<rules>
        <!-- дата модификации правил-->
        <created>2013-08-28 13:40:43.418</created>
        <!-- группа правил-->
        <rulesData>
            <!-- случайно сгенерированная строка-->
            <uid>e873e4a4-0fc5-11e3-b964-1c6f65abc641</uid>
            <!-- описание конкрентного правила-->
            <rule ignoreOnExport="false" preserveOnImport="false">
                <!-- случайно сгенерированная строка-->
                <uid>44e08c90-ee05-11e2-9b64-0050569b007b</uid>
                <!-- строка из списка Применимо к-->
                <target>PRODUCT_COMMISSION</target>
                <!-- строка описания правила-->
                <remarks>
                    Правило на класс обслуживания
                </remarks>
                <!-- Список условий, их количество может варьироваться  от нуля до бесконечности-->
                <!-- Первое условие-->
                <restriction>
                    <!-- строка из списка Свойства-->
                    <property>SERVICE_CLASSES</property>
                    <!-- строка из списка Условия-->
                    <condition>INCLUDE</condition>
                    <!-- Описание объекта-значения (см раздел Возможные значения условий); значения может и не быть вообще-->
                    <value class="java.util.LinkedList">
                            <item class="com.gridnine.xtrip.common.model.dict.ClassOfService">BUSINESS</item>
                    </value>
                </restriction>
                <!-- Второе условие-->
                <restriction>
                    <property>CARRIERS</property>
                    <condition>INCLUDE</condition>
                    <value class="java.lang.String">
                            DL
                    </value>
                </restriction>
                <!-- Третье условие-->
                <restriction>
                    <property>TARIFF_TYPE</property>
                    <condition>TARIFF_TYPE_REGULAR</condition>
                </restriction>
                <!-- Список действий, их количество может варьроваться  от 1 до бесконечности-->
                <result>
                    <!-- строка из списка Действия(actions) -->
                    <action>SIMPLE_FEE</action>
                    <!-- описание действия -->
                    <value class="com.gridnine.xtrip.common.model.rules.standard.RuleResultValue">
                         <value>200.0</value>
                         <currencyCode>RUB</currencyCode>
                         <target class="com.gridnine.xtrip.common.model.EntityReference">
                              <uid>2121be94-c8bb-42e8-858c-4b114a1668f7</uid>
                                <type>
                                   com.gridnine.xtrip.common.model.booking.commission.FeeProperties
                                </type>
                                <caption>
                                    web-сбор" Продажа Билет"
                                </caption>
                         </target>
                     </value>
                </result>
            </rule>
        </rulesData>
</rules>
""") }
        h2("Список Применимо к")
        table(border:"1"){
            tr{
                th("id")
                th("Название")
                th("Комментарий")
            }
            def targets = []
            targets.addAll(Environment.getPublished(RulesEnvironment.class).getTargets(null))
            targets.sort{it.displayName}
            targets.each {RuleTarget target ->
                tr{
                    td("${target.id}")
                    td("${target.displayName}")
                    writeDescriptions(html, targetsDescription[target.id])
                }
            }
        }
        h2("Список Условия")
        table(border:"1"){
            tr{
                th("id")
                th("Название")
                th("Комментарий")
            }
            def conditions = new HashSet()
            Environment.getPublished(RulesEnvironment.class).getTargets(null).each{
                Environment.getPublished(RulesEnvironment.class).getProperties(it).each{
                    Environment.getPublished(RulesEnvironment.class).getConditions(it).each{ conditions << it }
                }
            }
            def lst = []
            lst.addAll(conditions)
            lst.sort{it.displayName}
            lst.each {RuleCondition condition ->
                tr{
                    td("${condition.id}")
                    td("${condition.displayName}")
                    writeDescriptions(html, targetsDescription[condition.id] )
                }
            }
        }
        h2("Список Свойства")
        table(border:"1"){
            tr{
                th("id")
                th("Название")
                th("Применимые условия")
                th("Тип значения")
                th("Применимо к")
                th(){
                    pre("Комментарий                                     ")
                }
            }
            def properties = new HashSet()
            def targetsMap = [:]
            Environment.getPublished(RulesEnvironment.class).getTargets(null).each{RuleTarget target ->
                Environment.getPublished(RulesEnvironment.class).getProperties(target).each{
                    if(it.id.contains('-')){
                        return
                    }
                    properties << it
                    Set targets =targetsMap[it]
                    if(!targets){
                        targets = new HashSet()
                        targetsMap[it] = targets
                    }
                    targets<<target.displayName
                }
            }
            def lst = []
            lst.addAll(properties)
            lst.sort{it.displayName}
            lst.each {RuleProperty property ->
                tr{
                    td("${property.id}")
                    td("${property.displayName}")
                    td("${Environment.getPublished(RulesEnvironment.class).getConditions(property)}")
                    try{
                            td(){
                                a(href:"#condition_${property.getRendererId()}"){
                                    String condition = "${property.getRendererId()}"
                                    if(condition.length() > 25){
                                        condition = condition.replace(".", ". ").replace("_", "_ ")
                                    }
                                    mkp.yield(condition)
                                }
                            }
                    } catch(Exception e){
                        td("")
                    }
                    td("${targetsMap[property].size() == 1? targetsMap[property].iterator().next(): targetsMap[property]}")
                    writeDescriptions(html, propertiesDescription[property.id] )
                }
            }
        }
        h2("Типы значений свойств")
        table(border:"1"){
            tr{
                th("id")
                th("Комментарий")
            }
            def values = new HashSet()
            Environment.getPublished(RulesEnvironment.class).getTargets(null).each{
                Environment.getPublished(RulesEnvironment.class).getProperties(it).each{
                    if(it.id.contains('-')){
                        return
                    }
                    try{
                        values<<it.getRendererId()
                    } catch(Exception e){
                    }
                }
            }
            def lst = []
            lst.addAll(values)
            lst.sort{it}
            lst.each {String value ->
                tr{
                    td(){
                        a(id:"condition_${value}"){
                            mkp.yield(value)
                        }
                    }
                    writeDescriptions(html, propertyValuesDescription[value] )
                }
            }
        }
        h2("Действия")
        table(border:"1"){
            tr{
                th("id")
                th("Название")
                th("Тип значения")
                th("Комментарий")
            }
            def actions = new HashSet()
            Environment.getPublished(RulesEnvironment.class).getTargets(null).each{
                Environment.getPublished(RulesEnvironment.class).getActions(it).each{
                    if(it.id.contains('-')){
                        return
                    }
                    actions << it
                }
            }
            def lst = []
            lst.addAll(actions)
            lst.sort{it.displayName}
            lst.each {RuleAction action ->
                tr{
                    td("${action.id}")
                    td("${action.displayName}")
                    try{
                            td(){
                                a(href:"#action_${action.getRendererId()}"){
                                    String renderer = "${action.getRendererId()}"
                                    if(renderer.length() > 25){
                                        renderer = renderer.replace(".", ". ").replace("_", "_ ")
                                    }
                                    mkp.yield(renderer)
                                }
                            }
                    } catch(Exception e){
                        td("")
                    }
                    writeDescriptions(html, actionValuesDescription[action.id] )
                }
            }
        }
        h2("Типы значений действий")
        table(border:"1"){
            tr{
                th("id")
                th("Комментарий")
            }
            def values = new HashSet()
            Environment.getPublished(RulesEnvironment.class).getTargets(null).each{
                Environment.getPublished(RulesEnvironment.class).getActions(it).each{
                    if(it.id.contains('-')){
                        return
                    }
                    try{
                        values<<it.getRendererId()
                    } catch(Exception e){
                    }
                }
            }
            def lst = []
            lst.addAll(values)
            lst.sort{it}
            lst.each {String value ->
                tr{
                    td(){
                        a(id:"action_${value}"){
                            mkp.yield(value)
                        }
                    }
                    writeDescriptions(html, actionValuesDescription[value] )
                }
            }
        }
    }
}

class ItemDescription{
    String type;

    String content;
}
