import com.gridnine.xtrip.common.model.EntityContainer
import com.gridnine.xtrip.common.model.EntityReference
import com.gridnine.xtrip.common.Environment
import com.gridnine.xtrip.common.model.entity.EntityStorage
import com.gridnine.xtrip.common.search.SearchCriterion
import com.gridnine.xtrip.common.search.SearchQuery
import com.gridnine.xtrip.common.search.SortOrder
import com.gridnine.xtrip.common.search.utils.SearchQueryHelper
import com.gridnine.xtrip.common.util.TextUtil
import com.gridnine.xtrip.common.model.profile.Organization
import com.gridnine.xtrip.common.model.booking.taxi.TaxiProductIndex
import com.gridnine.xtrip.common.model.finance.Shipment
import com.gridnine.xtrip.common.model.finance.ShipmentIndex
import java.util.stream.Collectors
import java.text.SimpleDateFormat;
import java.util.Calendar;
import groovy.transform.Field
import org.apache.commons.lang.time.FastDateFormat


@Field String fileSuffix = FastDateFormat.getInstance("yyyy.MM.dd_HH.mm").format(new Date());
@Field FastDateFormat DTF = FastDateFormat.getInstance("dd.MM.yyyy HH:mm");

@Field boolean onlyLook = true

if (onlyLook) {
    fileMessage("Режим 'Только просмотр' ")
}
doJob()

void doJob() {

    int errors = 0
    int productsCount = 0
    int shipmentsCount = 0
    int resultCount = 0

    String organizationName = ""
    String startDateString = ""
    String endDateString = ""
    String result = ""

    try {
        SimpleDateFormat format = new SimpleDateFormat("dd.MM.yyyy")
        Calendar calendar = Calendar.getInstance()
        calendar.set(2022, Calendar.JANUARY, 1)
        Date startDate = calendar.getTime()
        startDateString = format.format(startDate)
        calendar.set(2022, Calendar.DECEMBER, 31)
        Date endDate = calendar.getTime()
        endDateString = format.format(endDate)

        Set<String> productUids = new HashSet<>()
        SearchQuery productQuery = new SearchQuery()
        EntityContainer<Organization> organizationCtr = EntityStorage.get().load(
            Organization.class, "d6d57d46-4232-4a22-aeb2-d3de4111d5f6")

        if (organizationCtr != null) {
            if (organizationCtr.getEntity().getShortName() != null) {
                organizationName = organizationCtr.getEntity().getShortName().toString()
            }
            EntityReference<Organization> organizationRef = organizationCtr.toReference()
            productQuery.getCriteria().getCriterions()
                .add(SearchCriterion.eq(
                    TaxiProductIndex.Property.blankOwner.name(), organizationRef))
        }

        List<SearchCriterion> productCriterions = new ArrayList<>();
        productCriterions.add(SearchCriterion.gt(
            TaxiProductIndex.Property.issueDate.name(),startDate));
        productCriterions.add(SearchCriterion.le(
            TaxiProductIndex.Property.issueDate.name(),endDate));
        productQuery.getCriteria().getCriterions()
            .add(SearchCriterion.and(
                productCriterions.toArray(new SearchCriterion[productCriterions.size()])));
        productQuery.getPreferredProperties().add("navigationKey");

        List<TaxiProductIndex> taxiProductIndices = EntityStorage.get()
            .search(TaxiProductIndex.class, productQuery).getData()
        for (TaxiProductIndex index : taxiProductIndices) {
            productUids.add(index.getNavigationKey());
        }
        productsCount = productUids.size()

        SearchQuery shipmentQuery = new SearchQuery()
        shipmentQuery.getCriteria().getCriterions()
            .add(SearchQueryHelper.buildOrContainsStringCriterion(
                ShipmentIndex.Property.productUids.name(),productUids))
        List<SearchCriterion> shipmentList = new ArrayList<>();
            shipmentList.add(SearchCriterion.gt(
                ShipmentIndex.Property.date.name(),startDate));
            shipmentList.add(SearchCriterion.le(
                ShipmentIndex.Property.date.name(),endDate));
            shipmentQuery.getCriteria().getCriterions()
                .add(SearchCriterion.and(
                    shipmentList.toArray(new SearchCriterion[shipmentList.size()])));
        shipmentQuery.getPreferredProperties().add(
            ShipmentIndex.Property.productUids.name());

        List<ShipmentIndex> shipmentIndices = EntityStorage.get()
            .search(ShipmentIndex.class, shipmentQuery).getData()
        shipmentsCount = shipmentIndices.size()

        StringBuilder builder = new StringBuilder()
        for (String uid : productUids) {
            Set<EntityReference<Shipment>> shipments = shipmentIndices.stream()
                .filter({item -> item.getProductUids().contains(uid)})
                .map({item -> item.getSource()})
                .filter({item -> item != null})
                .collect(Collectors.toSet());
            if (shipments.size() > 1) {
                SearchQuery query = new SearchQuery()
                query.getCriteria().getCriterions().add(
                        SearchCriterion.eq("navigationKey", uid))
                query.getPreferredProperties().add(
                    TaxiProductIndex.Property.systemNumber.name())
                query.getPreferredProperties().add(
                    TaxiProductIndex.Property.status.name())
                List<TaxiProductIndex> indices = EntityStorage.get().search(
                        TaxiProductIndex.class, query).getData()
                if (indices.size() == 1) {
                    TaxiProductIndex index = indices.get(0)
                    builder.append(index.getSystemNumber())
                    builder.append(" ")
                    builder.append(index.getStatus())
                    builder.append(":\n")
                    builder.append(
                        shipments.stream()
                            .map({item -> item.getCaption()})
                            .collect(Collectors.joining(" | ")))
                    builder.append("\n")
                    builder.append("\n")

                    resultCount++
                }
            }
        }
        result = builder.toString()

    } catch (Exception ex) {
        errors++;
        fileMessage("${TextUtil.getExceptionStackTrace(ex)}", false)
    }

    fileMessage("")
    fileMessage("Владелец бланка: ${organizationName}")
    fileMessage("\nНайдено ${productsCount} продуктов Яндекс.Такси с датой выписки ${startDateString} - ${endDateString}")
    fileMessage("\nНайдено ${shipmentsCount} реализаций с продуктами Яндекс.Такси за период ${startDateString} - ${endDateString}")
    fileMessage("\nНайдено ${resultCount} продкутов Яндекс.Такси, включенных в несколько реализаций:")
    fileMessage("\n${result}")
    fileMessage("Итого возникло ${errors} ошибок")
}

void fileMessage(String str){
    fileMessage(str, true)
}

void fileMessage(String str, boolean writeToConsole){
    if (writeToConsole){
        message(str)
    }
    new File(Environment.getRootFolder(), "/logs/TUIBT2262_${fileSuffix}.txt")
            .append("${DTF.format(new Date())}: ${str} \n")
}