SELECT
    c.table_name,
    c.column_name,
    CASE
        WHEN c.is_array THEN
            CASE
                WHEN bt.typname = 'text' THEN 'text[]'
                WHEN bt.typname = 'int4' THEN 'integer[]'
                WHEN bt.typname = 'int8' THEN 'bigint[]'
                WHEN bt.typname = 'varchar' THEN 'character varying[]'
                WHEN bt.typname = 'bool' THEN 'boolean[]'
                WHEN bt.typname = 'float8' THEN 'double precision[]'
                WHEN bt.typname = 'float4' THEN 'real[]'
                WHEN bt.typname = 'numeric' THEN 'numeric[]'
                WHEN bt.typname = 'timestamp' THEN 'timestamp[]'
                WHEN bt.typname = 'timestamptz' THEN 'timestamp with time zone[]'
                WHEN bt.typname = 'date' THEN 'date[]'
                WHEN bt.typname = 'time' THEN 'time[]'
                WHEN bt.typname = 'timetz' THEN 'time with time zone[]'
                WHEN bt.typname = 'uuid' THEN 'uuid[]'
                WHEN bt.typname = 'jsonb' THEN 'jsonb[]'
                WHEN bt.typname = 'json' THEN 'json[]'
                WHEN bt.typname = 'bpchar' THEN 'character[]'
                ELSE COALESCE(bt.typname, 'unknown') || '[]'
            END
        ELSE c.data_type
    END AS data_type,
    c.column_default,
    c.character_maximum_length,
    c.numeric_precision,
    c.numeric_scale,
    c.is_nullable
FROM (
    SELECT
        nc.nspname::information_schema.sql_identifier AS table_schema,
        c.relname::information_schema.sql_identifier AS table_name,
        a.attname::information_schema.sql_identifier AS column_name,
        pg_get_expr(ad.adbin, ad.adrelid)::information_schema.character_data AS column_default,
        CASE
            WHEN a.attnotnull OR (t.typtype = 'd' AND t.typnotnull) THEN 'NO'
            ELSE 'YES'
        END::information_schema.yes_or_no AS is_nullable,
        CASE
            WHEN t.typelem <> 0 AND t.typlen = -1 THEN
                CASE
                    WHEN nt.nspname = 'pg_catalog' THEN format_type(t.typelem, NULL)
                    ELSE 'USER-DEFINED'
                END
            WHEN t.typtype = 'd' THEN
                CASE
                    WHEN bt.typelem <> 0 AND bt.typlen = -1 THEN
                        CASE
                            WHEN nbt.nspname = 'pg_catalog' THEN format_type(bt.typelem, NULL)
                            ELSE 'USER-DEFINED'
                        END
                    WHEN nbt.nspname = 'pg_catalog' THEN format_type(t.typbasetype, NULL)
                    ELSE 'USER-DEFINED'
                END
            WHEN nt.nspname = 'pg_catalog' THEN format_type(a.atttypid, NULL)
            ELSE 'USER-DEFINED'
        END AS data_type,
        information_schema._pg_char_max_length(information_schema._pg_truetypid(a, t), information_schema._pg_truetypmod(a, t))::information_schema.cardinal_number AS character_maximum_length,
        information_schema._pg_numeric_precision(information_schema._pg_truetypid(a, t), information_schema._pg_truetypmod(a, t))::information_schema.cardinal_number AS numeric_precision,
        information_schema._pg_numeric_scale(information_schema._pg_truetypid(a, t), information_schema._pg_truetypmod(a, t))::information_schema.cardinal_number AS numeric_scale,
        a.attnum::information_schema.sql_identifier AS dtd_identifier,
        (t.typelem <> 0 AND t.typlen = -1) OR (t.typtype = 'd' AND bt.typelem <> 0 AND bt.typlen = -1) AS is_array,
        COALESCE(t.typelem, bt.typelem) AS array_element_type
    FROM pg_attribute a
    JOIN pg_class c ON a.attrelid = c.oid
    JOIN pg_namespace nc ON c.relnamespace = nc.oid
    JOIN pg_type t ON a.atttypid = t.oid
    JOIN pg_namespace nt ON t.typnamespace = nt.oid
    LEFT JOIN pg_attrdef ad ON a.attrelid = ad.adrelid AND a.attnum = ad.adnum
    LEFT JOIN pg_type bt ON t.typtype = 'd' AND t.typbasetype = bt.oid
    LEFT JOIN pg_namespace nbt ON bt.typnamespace = nbt.oid
    WHERE nc.nspname = 'public'
        AND NOT pg_is_other_temp_schema(nc.oid)
        AND a.attnum > 0
        AND NOT a.attisdropped
        AND c.relkind IN ('r', 'v', 'f', 'p') -- Только таблицы, представления, внешние и партиционные таблицы
        AND (pg_has_role(c.relowner, 'USAGE')
             OR has_column_privilege(c.oid, a.attnum, 'SELECT, INSERT, UPDATE, REFERENCES'))
) AS c
LEFT JOIN pg_type bt ON c.array_element_type = bt.oid;