import org.slf4j.Logger
import org.slf4j.LoggerFactory

import com.gridnine.xtrip.common.model.EntityContainer
import com.gridnine.xtrip.common.model.entity.EntityStorage
import com.gridnine.xtrip.common.model.profile.Organization
import com.gridnine.xtrip.common.model.profile.OrganizationIndex
import com.gridnine.xtrip.common.model.profile.OrganizationType
import com.gridnine.xtrip.common.model.profile.ProfileKeyContactPerson
import com.gridnine.xtrip.common.model.profile.SabreKeyContactEmailType
import com.gridnine.xtrip.common.search.SearchCriterion
import com.gridnine.xtrip.common.search.SearchQuery
import com.gridnine.xtrip.common.search.SortOrder

Logger logger = LoggerFactory.getLogger('groovy-script')

logger.info("person key contacts update: started")

int countt = 0
int amount = 10000

int processed = 0
int updated = 0

try {

    while(true) {

        int limit = amount
        int offset = countt * amount

        logger.info("person key contacts update: searching " + limit + " starting from " + offset)

        SearchQuery query = new SearchQuery()

        query.setLimit(limit)
        query.setOffset(offset)

        query.getCriteria().getCriterions().add(SearchCriterion.contains(OrganizationIndex.Property.types.name(), OrganizationType.CORPORATE_CLIENT))
        
        query.getCriteria().orders.put("containerUid", SortOrder.ASC)

        query.getPreferredProperties().add("containerUid")

        List<OrganizationIndex> indexes = EntityStorage.get().search(OrganizationIndex.class, query).getData()

        logger.info("person key contacts update: found " + indexes.size() + " profiles")

        if(indexes.size() == 0) {
            break
        }

        for(OrganizationIndex index : indexes) {

            logger.info("person key contacts update: processing " + processed + " | " + updated + " | " + index.getSource().getUid())

            EntityContainer<Organization> organizationContainer = EntityStorage.get().resolve(index.getSource())

            if(organizationContainer != null) {

                Organization organization = organizationContainer.getEntity()

                boolean save = false;
                
                for(ProfileKeyContactPerson keyContact : organization.getKeyContacts()) {
                    
                    if(keyContact.getEmailType() == null) {
                        
                        keyContact.setEmailType(SabreKeyContactEmailType.CC)
                        save = true;
                    }
                }
                
                if(save) {
                    
                    logger.info("person key contacts update: update key contact(s) " + index.getSource() + " (" + index.getSource().getUid() + ")")
                    
                    organizationContainer.getVersionInfo().setDataSource("person-key-contacts-update-task")
                    
                    EntityStorage.get().save(organizationContainer, false)
                    
                    updated++
                }
                
            } else {
                logger.info("person key contacts update: unable to load " + index.getSource() + " (" + index.getSource().getUid() + ")")
            }

            processed++
        }

        countt++
    }
    
} catch(Throwable t) {
    logger.error('person key contacts update: error occured', t)
}

logger.info("person key contacts update: processed " + processed)
logger.info("person key contacts update: updated " + updated)

logger.info("person key contacts update: finished")
