<%@page import="com.gridnine.xtrip.common.model.EntityIndex"%>
<%@page import="com.gridnine.xtrip.server.db.storage.model.IndexHandler"%>
<%@page import="com.gridnine.xtrip.common.model.BaseEntity"%>
<%@page
	import="com.gridnine.xtrip.server.db.storage.model.PhysicalEntityData"%>
<%@page
	import="com.gridnine.xtrip.server.db.storage.model.EntityPhysicalStorage"%>
<%@page
	import="com.gridnine.xtrip.server.db.storage.model.PhysicalStorageSession"%>
<%@page
	import="com.gridnine.xtrip.server.db.storage.model.PhysicalStorage"%>
<%@page
	import="com.gridnine.xtrip.server.db.storage.common.LogicalStorageRegistry"%>
<%@page import="com.gridnine.xtrip.server.db.storage.LogicalStorage"%>
<%@page import="com.gridnine.xtrip.common.xml.XHelper"%>
<%@page import="com.gridnine.xtrip.common.util.ObjectFilter"%>
<%@page import="com.gridnine.xtrip.common.util.CollectionUtil"%>
<%@page import="java.util.ArrayList"%>
<%@page import="com.gridnine.xtrip.common.util.TextUtil"%>
<%@page import="java.util.Comparator"%>
<%@page import="java.util.Collections"%>
<%@page import="com.gridnine.xtrip.common.meta.MetaRegistry"%>
<%@page import="com.gridnine.xtrip.common.Environment"%>
<%@page import="com.gridnine.xtrip.common.meta.EntityType"%>
<%@page import="java.util.List"%>
<%@ page language="java" contentType="text/html; charset=utf-8"%><%!//
    static <E extends BaseEntity> boolean delete(Class<E> cls, String uid)
            throws Exception {
        LogicalStorageRegistry lsr = Environment
                .getPublished(LogicalStorageRegistry.class);
        PhysicalStorage ps = lsr.getStorage(LogicalStorage.get()
                .getPrimaryStorageUid());
        EntityPhysicalStorage eps = ps.getEntityStorage();
        PhysicalStorageSession ss = ps.createSession();
        try {
            ss.begin();
            if (!eps.isEntityAvailable(cls, uid, ss)) {
                return false;
            }
            {
                PhysicalEntityData<E> data = new PhysicalEntityData<E>();
                data.setUid(uid);
                data.setEntityType(cls);
                eps.deleteEntity(data, ss);
            }
            List restoreData = new ArrayList();
            for (IndexHandler<E, EntityIndex<E>> handler : lsr
                    .getIndexHandlers(cls)) {
                eps.deleteIndexes(handler.getIndexClass(), uid, restoreData, ss);
            }
            ss.commit();
        } finally {
            ss.rollback();
        }
        return true;
    }%>
<%
    String message = null;
    Exception error = null;
    if (request.getParameter("delete") != null) {
        try {
            Class<BaseEntity> ett = (Class<BaseEntity>) XHelper
                    .getClass(request.getParameter("ett"));
            String[] uids = request.getParameter("uids").trim()
                    .split("[\\s\\;\\,]");
            int count = 0;
            for (String uid : uids) {
                if (TextUtil.isBlank(uid)) {
                    continue;
                }
                if (delete(ett, uid)) {
                    count++;
                }
            }
            message = "Entities deleted: " + count;
        } catch (Exception e) {
            error = e;
            message = "An error has occurred: " + e.getMessage();
        }
    }
%>
<!doctype html>
<html>
<head>
<title>Deleting Entity - <%=application.getServletContextName()%></title>
<link rel="StyleSheet" type="text/css" href="../resources/base.css">
</head>
<body style="padding: 1em">
	<%
	    if (message != null) {
	%>
	<h3><%=message%></h3>
	<p>
		<a href="entity-delete.jsp">Back to form page</a>
	</p>
	<%
	    if (error != null) {
	%>
	<h4>Error details:</h4>
	<pre><%=TextUtil.getExceptionStackTrace(error)%></pre>
	<%
	    }
	%>
	<%
	    } else {
	%>
	<h3>Delete entity using physical storage</h3>
	<p>
		<strong>CAUTION!</strong><br> This tool uses direct access to the
		primary physical storage. It means that no interceptors and other
		logical storage actors will be invoked during delete operation.
	</p>
	<form action="entity-delete.jsp" method="post">
		<p>
			<label for="ett">Entity type</label> <select id="ett" name="ett">
				<%
				    List<EntityType> list = new ArrayList<EntityType>(Environment
				                .getPublished(MetaRegistry.class).getEntities()
				                .values());
				        CollectionUtil.filter(list, new ObjectFilter<EntityType>() {
				            @Override
				            public boolean accept(EntityType obj) {
				                return obj.isRoot() && !obj.isAbstract();
				            }
				        });
				        Collections.sort(list, new Comparator<EntityType>() {
				            @Override
				            public int compare(EntityType o1, EntityType o2) {
				                return TextUtil.compare(o1.getDisplayName(),
				                        o2.getDisplayName(), true, true);
				            }
				        });
				        for (EntityType ett : list) {
				%>
				<option value="<%=ett.getId()%>"><%=ett.getDisplayName()%></option>
				<%
				    }
				%>
			</select><br> <label for="uids">Entity UID's</label> (separate them with
			white space, ',' or ';' characters)<br>
			<textarea name="uids" rows="10" cols="80"></textarea>
			<br> <input type="submit" name="delete" value="Delete"
				onclick="return confirm('Sure to start delete operation?')">
		</p>
	</form>
	<%
	    }
	%>
</body>
</html>
