<%@ page language="java" contentType="text/html; charset=utf-8"
	errorPage="../error.jsp" import="java.util.*" import="java.text.*"
	import="com.gridnine.xtrip.common.*"
	import="com.gridnine.xtrip.common.xml.*"
	import="com.gridnine.xtrip.common.util.*"
	import="com.gridnine.xtrip.common.meta.*"%><%!static boolean isRegisteredType(String id) {
        MetaRegistry registry = Environment.getPublished(MetaRegistry.class);
        return registry.getDictionaries().containsKey(id)
            || registry.getEntities().containsKey(id)
            || registry.getEnums().containsKey(id)
            || registry.getIndexes().containsKey(id);
    }

    static Set<IndexType> getIndexesFor(String entityId) {
        MetaRegistry registry = Environment.getPublished(MetaRegistry.class);
        Set<IndexType> result = new HashSet<IndexType>();
        for (IndexType idx : registry.getIndexes().values()) {
            if (entityId.equals(idx.getEntityId())) {
                result.add(idx);
            }
        }
        return result;
    }

    static final Comparator<BaseType> COMPARATOR = new Comparator<BaseType>() {
        public int compare(BaseType o1, BaseType o2) {
            return TextUtil.compare(o1.getDisplayName(), o2.getDisplayName(),
                true, true);
        }
    };%>
<%
    MetaRegistry registry = Environment
        .getPublished(MetaRegistry.class);
%>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
<head>
<title>Meta Browser - <%=application.getServletContextName()%></title>
<link rel="StyleSheet" type="text/css" href="../resources/base.css">
<script type="text/javascript" src="../resources/lib.js"></script>
</head>

<body>

	<table width="100%">
		<tr>
			<td align="center"><a href="#indexes">Indexes</a></td>
			<td align="center"><a href="#enums">Enumerations</a></td>
			<td align="center"><a href="#dicts">Dictionaries</a></td>
			<td align="center"><a href="#entities">Entities</a></td>
		</tr>
	</table>

	<%
	    {
	        List<IndexType> list = new ArrayList<IndexType>(registry
	            .getIndexes().values());
	        Collections.sort(list, COMPARATOR);
	%>
	<h3>
		<a name="indexes" href="javascript:toggleVisible('indexes')">Indexes</a>
		(<%=list.size()%>)
	</h3>
	<dl id="indexes" style="display: block;">
		<%
		    for (IndexType idx : list) {
		%>
		<dt <%=idx.isDeprecated() ? "class='deprecated'" : ""%>>
			<a name="<%=idx.getId()%>"><%=idx.getDisplayName()%></a>
		</dt>
		<dd>
			ID:
			<%=idx.getId()%><br /> Entity ID:
			<%=idx.getEntityId()%><br /> Hidden:
			<%=idx.isHidden()%><br />
			<table border="1" cellspacing="0" cellpadding="5">
				<caption>Properties</caption>
				<tr>
					<th>ID</th>
					<th>Type</th>
					<th>Unique</th>
					<th>System</th>
					<th>Cached</th>
					<th>Viewable</th>
					<th>Searchable</th>
					<th>Filterable</th>
				</tr>
				<%
				    for (IndexProperty prop : idx.getProperties().values()) {
				%>
				<tr <%=prop.isDeprecated() ? "class='deprecated'"
                            : ""%>>
					<td title="<%=prop.getDisplayName()%>"><%=prop.getId()%></td>
					<%
					    if (isRegisteredType(prop.getType())) {
					%>
					<td><a href="#<%=prop.getType()%>"><%=prop.getType()%></a></td>
					<%
					    } else {
					%>
					<td><%=prop.getType()%></td>
					<%
					    }
					%>
					<td><%=prop.isUnique()%></td>
					<td><%=prop.isSystem()%></td>
					<td><%=prop.isCached()%></td>
					<td><%=prop.isViewable()%></td>
					<td><%=prop.isSearchable()%></td>
					<td><%=prop.isFilterable()%></td>
				</tr>
				<%
				    }
				%>
			</table>
			<table border="1" cellspacing="0" cellpadding="5">
				<caption>Collections</caption>
				<tr>
					<th>ID</th>
					<th>Element Type</th>
					<th>Type</th>
					<th>Cached</th>
					<th>Viewable</th>
					<th>Searchable</th>
					<th>Filterable</th>
				</tr>
				<%
				    for (IndexCollection coll : idx.getCollections().values()) {
				%>
				<tr <%=coll.isDeprecated() ? "class='deprecated'"
                            : ""%>>
					<td title="<%=coll.getDisplayName()%>"><%=coll.getId()%></td>
					<%
					    if (isRegisteredType(coll.getType())) {
					%>
					<td><a href="#<%=coll.getType()%>"><%=coll.getType()%></a></td>
					<%
					    } else {
					%>
					<td><%=coll.getType()%></td>
					<%
					    }
					%>
					<td><%=coll.getElementType()%></td>
					<td><%=coll.isSystem()%></td>
					<td><%=coll.isViewable()%></td>
					<td><%=coll.isSearchable()%></td>
					<td><%=coll.isFilterable()%></td>
				</tr>
				<%
				    }
				%>
			</table>
		</dd>
		<%
		    }
		    }
		%>
	</dl>

	<%
	    {
	        List<EnumType> list = new ArrayList<EnumType>(registry
	            .getEnums().values());
	        Collections.sort(list, COMPARATOR);
	%>
	<h3>
		<a name="enums" href="javascript:toggleVisible('enums')">Enumerations</a>
		(<%=list.size()%>)
	</h3>
	<dl id="enums" style="display: block;">
		<%
		    for (EnumType enm : list) {
		%>
		<dt <%=enm.isDeprecated() ? "class='deprecated'" : ""%>>
			<a name="<%=enm.getId()%>"><%=enm.getDisplayName()%></a>
		</dt>
		<dd>
			ID:
			<%=enm.getId()%><br />
			<table border="1" cellspacing="0" cellpadding="5">
				<caption>Elements</caption>
				<tr>
					<th>ID</th>
					<th>Name</th>
				</tr>
				<%
				    for (EnumItem item : enm.getItems().values()) {
				%>
				<tr <%=item.isDeprecated() ? "class='deprecated'"
                            : ""%>>
					<td><%=item.getId()%></td>
					<td><%=item.getDisplayName()%></td>
				</tr>
				<%
				    }
				%>
			</table>
		</dd>
		<%
		    }
		    }
		%>
	</dl>

	<%
	    {
	        List<DictionaryType> list = new ArrayList<DictionaryType>(
	            registry.getDictionaries().values());
	        Collections.sort(list, COMPARATOR);
	%>
	<h3>
		<a name="dicts" href="javascript:toggleVisible('dicts')">Dictionaries</a>
		(<%=list.size()%>)
	</h3>
	<dl id="dicts" style="display: block;">
		<%
		    for (DictionaryType dict : list) {
		%>
		<dt <%=dict.isDeprecated() ? "class='deprecated'" : ""%>>
			<a name="<%=dict.getId()%>"><%=dict.getDisplayName()%></a>
		</dt>
		<dd>
			ID:
			<%=dict.getId()%><br />
			<%
			    if (dict.getExtendsId() != null) {
			%>
			<%
			    if (isRegisteredType(dict.getExtendsId())) {
			%>
			Extends: <a href="#<%=dict.getExtendsId()%>"><%=dict.getExtendsId()%></a><br />
			<%
			    } else {
			%>
			Extends:
			<%=dict.getExtendsId()%><br />
			<%
			    }
			%>
			<%
			    }
			%>
			<table border="1" cellspacing="0" cellpadding="5">
				<caption>Properties</caption>
				<tr>
					<th>ID</th>
					<th>Type</th>
				</tr>
				<%
				    for (DictionaryProperty prop : dict.getProperties()
				                .values()) {
				%>
				<tr <%=prop.isDeprecated() ? "class='deprecated'"
                            : ""%>>
					<td title="<%=prop.getDisplayName()%>"><%=prop.getId()%></td>
					<%
					    if (isRegisteredType(prop.getType())) {
					%>
					<td><a href="#<%=prop.getType()%>"><%=prop.getType()%></a></td>
					<%
					    } else {
					%>
					<td><%=prop.getType()%></td>
					<%
					    }
					%>
				</tr>
				<%
				    }
				%>
			</table>
			<table border="1" cellspacing="0" cellpadding="5">
				<caption>Collections</caption>
				<tr>
					<th>ID</th>
					<th>Element Type</th>
					<th>Type</th>
					<th>Reference</th>
				</tr>
				<%
				    for (EntityCollection coll : dict.getCollections().values()) {
				%>
				<tr <%=coll.isDeprecated() ? "class='deprecated'"
                            : ""%>>
					<td title="<%=coll.getDisplayName()%>"><%=coll.getId()%></td>
					<%
					    if (isRegisteredType(coll.getType())) {
					%>
					<td><a href="#<%=coll.getType()%>"><%=coll.getType()%></a></td>
					<%
					    } else {
					%>
					<td><%=coll.getType()%></td>
					<%
					    }
					%>
					<td><%=coll.getElementType()%></td>
					<td><%=coll.isReference()%></td>
				</tr>
				<%
				    }
				%>
			</table>
		</dd>
		<%
		    }
		    }
		%>
	</dl>

	<%
	    {
	        List<EntityType> list = new ArrayList<EntityType>(registry
	            .getEntities().values());
	        Collections.sort(list, COMPARATOR);
	%>
	<h3>
		<a name="entities" href="javascript:toggleVisible('entities')">Entities</a>
		(<%=list.size()%>)
	</h3>
	<dl id="entities" style="display: block;">
		<%
		    for (EntityType ett : list) {
		%>
		<dt <%=ett.isDeprecated() ? "class='deprecated'" : ""%>>
			<a name="<%=ett.getId()%>"><%=ett.getDisplayName()%></a>
		</dt>
		<dd>
			ID:
			<%=ett.getId()%><br /> Root:
			<%=ett.isRoot()%><br />
			<%
			    if (ett.isRoot()) {
			%>
			Indexes:
			<%
			    int i = 0;
			                for (IndexType idx : getIndexesFor(ett.getId())) {
			%><%=(i++ > 0) ? ", " : ""%><a
				<%=idx.isDeprecated() ? "class='deprecated'"
                                : ""%>
				href="#<%=idx.getId()%>"><%=idx.getDisplayName()%></a>
			<%
			    }
			%>
			<br />
			<%
			    }
			%>
			<%
			    if (!ett.getInterfaces().isEmpty()) {
			%>
			Interfaces:
			<%=CollectionUtil.collectionToString(
                            ett.getInterfaces(), ", ", false)%><br />
			<%
			    }
			%>
			<%
			    if (ett.getExtendsId() != null) {
			%>
			<%
			    if (isRegisteredType(ett.getExtendsId())) {
			%>
			Extends: <a <%=ett.isDeprecated() ? "class='deprecated'"
                                : ""%>
				href="#<%=ett.getExtendsId()%>"><%=ett.getExtendsId()%></a><br />
			<%
			    } else {
			%>
			Extends:
			<%=ett.getExtendsId()%><br />
			<%
			    }
			%>
			<%
			    }
			%>
			<table border="1" cellspacing="0" cellpadding="5">
				<caption>Properties</caption>
				<tr>
					<th>ID</th>
					<th>Type</th>
					<th>Readonly</th>
					<th>Reference</th>
				</tr>
				<%
				    for (Property prop : ett.getProperties().values()) {
				%>
				<tr <%=prop.isDeprecated() ? "class='deprecated'"
                            : ""%>>
					<td title="<%=prop.getDisplayName()%>"><%=prop.getId()%></td>
					<%
					    if (isRegisteredType(prop.getType())) {
					%>
					<td><a href="#<%=prop.getType()%>"><%=prop.getType()%></a></td>
					<%
					    } else {
					%>
					<td><%=prop.getType()%></td>
					<%
					    }
					%>
					<td><%=prop.isReadonly()%></td>
					<td><%=prop.isReference()%></td>
				</tr>
				<%
				    }
				%>
			</table>
			<table border="1" cellspacing="0" cellpadding="5">
				<caption>Collections</caption>
				<tr>
					<th>ID</th>
					<th>Element Type</th>
					<th>Type</th>
					<th>Reference</th>
				</tr>
				<%
				    for (EntityCollection coll : ett.getCollections().values()) {
				%>
				<tr <%=coll.isDeprecated() ? "class='deprecated'"
                            : ""%>>
					<td title="<%=coll.getDisplayName()%>"><%=coll.getId()%></td>
					<td><%=coll.getType()%></td>
					<%
					    if (isRegisteredType(coll.getElementType())) {
					%>
					<td><a href="#<%=coll.getElementType()%>"><%=coll.getElementType()%></a></td>
					<%
					    } else {
					%>
					<td><%=coll.getElementType()%></td>
					<%
					    }
					%>
					<td><%=coll.isReference()%></td>
				</tr>
				<%
				    }
				%>
			</table>
		</dd>
		<%
		    }
		    }
		%>
	</dl>

</body>
</html>
