<%@ page
	pageEncoding="UTF-8"
	contentType="text/html; charset=UTF-8"
	import="java.util.*"
	import="com.gridnine.xtrip.common.*"
	import="com.gridnine.xtrip.common.util.*"
	import="com.gridnine.xtrip.common.model.dict.*"
	import="com.gridnine.xtrip.server.storage.*"
%><%!String delete(final String countryCodes) throws Exception {
    Set<String> codes = new HashSet<String>();
    for(String code : countryCodes.split(",")) {
        if (!TextUtil.isBlank(code)) {
            codes.add(code.trim());
        }
    }
    if (codes.isEmpty()) {
        return "no country codes provided";
    }
    List<GeoLocation> locations = new LinkedList<GeoLocation>();
    for (GeoLocation loc : Environment.getPublished(DictionaryCache.class).getAll(GeoLocation.class).values()) {
        if ((loc.getCountry() != null) && countryCodes.contains(loc.getCountry().getCode())) {
        	locations.add(loc);
        }
    }
	DictionaryStorage ds = DictionaryStorage.get();
	for (GeoLocation loc : locations) {
	    ds.delete(loc);
	}
	return "deleted " + locations.size() + " dictionary items";
}%><%
String msg = null;
if (request.getParameter("delete") != null) {
    msg = delete(request.getParameter("countries"));
}
%><!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
<head>
	<title>GeoLocations Tools - <%= application.getServletContextName() %></title>
</head>

<body>

<form method="post">
Countries: <input type="text" name="countries" title="Comma separated list of country codes." style="width:30em" />
<input type="submit" name="delete" value="Delete GEO locations for given countries" />
</form>
<hr />

<% if (msg != null) { %>
<p><%= msg %></p>
<% } %>
</body>
</html>
